/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VMPauseGuard {
    private final long totalPauseTimeAtBegin;
    private final long totalPauseCountAtBegin;
    private static VMPauseStatsProvider DEFAULT = new DefaultProvider();

    public VMPauseGuard() {
        VMPauseStats stats = VMPauseGuard.getVMPauseStats();
        this.totalPauseTimeAtBegin = stats.totalPauseTime;
        this.totalPauseCountAtBegin = stats.totalPauseCount;
    }

    public long pauseTime() {
        VMPauseStats stats = VMPauseGuard.getVMPauseStats();
        return Math.max(stats.totalPauseTime - this.totalPauseTimeAtBegin, 0L);
    }

    public long pauseCount() {
        VMPauseStats stats = VMPauseGuard.getVMPauseStats();
        return Math.max(stats.totalPauseCount - this.totalPauseCountAtBegin, 0L);
    }

    static VMPauseStats getVMPauseStats() {
        return DEFAULT.get();
    }

    private static class DefaultProvider
    implements VMPauseStatsProvider {
        private final Runtime runtime;
        private long cachedTotalSafepointTime = -1L;
        private long cachedSafepointCount = -1L;
        private long lastUpdateTime = -1L;

        DefaultProvider() {
            Runtime rt;
            String className = "sun.management.ManagementFactoryHelper";
            try {
                Class<?> cls = Class.forName("sun.management.ManagementFactoryHelper");
                Method getHotspotRuntimeMBeanMethod = cls.getMethod("getHotspotRuntimeMBean", new Class[0]);
                Object runtime = getHotspotRuntimeMBeanMethod.invoke(null, new Object[0]);
                Method getSafepointCountMethod = runtime.getClass().getMethod("getSafepointCount", new Class[0]);
                getSafepointCountMethod.setAccessible(true);
                Method getTotalSafepointTimeMethod = runtime.getClass().getMethod("getTotalSafepointTime", new Class[0]);
                getTotalSafepointTimeMethod.setAccessible(true);
                rt = new Runtime(runtime, getSafepointCountMethod, getTotalSafepointTimeMethod);
            }
            catch (Throwable e) {
                System.err.println("Failed to load sun.management.ManagementFactoryHelper, VMPauseGuard will be ignored: " + e.getMessage());
                rt = null;
            }
            this.runtime = rt;
        }

        private void readFromHotspotRuntime() {
            if (this.runtime == null) {
                this.cachedSafepointCount = 0L;
                this.cachedTotalSafepointTime = 0L;
            } else {
                this.cachedSafepointCount = this.runtime.getSafepointCount();
                this.cachedTotalSafepointTime = this.runtime.getTotalSafepointTime();
            }
        }

        @Override
        public VMPauseStats get() {
            long now = System.currentTimeMillis();
            if (now > this.lastUpdateTime) {
                this.readFromHotspotRuntime();
                this.lastUpdateTime = now;
            }
            return new VMPauseStats(this.cachedTotalSafepointTime, this.cachedSafepointCount);
        }

        private static class Runtime {
            private Object runtime;
            private Method getSafepointCountMethod;
            private Method getTotalSafepointTimeMethod;

            Runtime(Object runtime, Method getSafepointCountMethod, Method getTotalSafepointTimeMethod) {
                this.runtime = runtime;
                this.getSafepointCountMethod = getSafepointCountMethod;
                this.getTotalSafepointTimeMethod = getTotalSafepointTimeMethod;
            }

            long getTotalSafepointTime() {
                try {
                    return (Long)this.getTotalSafepointTimeMethod.invoke(this.runtime, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    return 0L;
                }
                catch (InvocationTargetException e) {
                    return 0L;
                }
            }

            long getSafepointCount() {
                try {
                    return (Long)this.getSafepointCountMethod.invoke(this.runtime, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    return 0L;
                }
                catch (InvocationTargetException e) {
                    return 0L;
                }
            }
        }
    }

    public static interface VMPauseStatsProvider {
        public VMPauseStats get();
    }

    public static class VMPauseStats {
        public long totalPauseTime;
        public long totalPauseCount;

        public VMPauseStats(long totalPauseTime, long totalPauseCount) {
            this.totalPauseTime = totalPauseTime;
            this.totalPauseCount = totalPauseCount;
        }
    }
}

