/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.LindormWideColumnService;
import com.alibaba.lindorm.client.core.widecolumnservice.WPartialResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.WScanner;
import com.alibaba.lindorm.client.core.widecolumnservice.WTimeRange;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class HotColdMergeScanner
extends WScanner {
    private LinkedList<WResult> cache = new LinkedList();
    private boolean needLoadingCache = true;
    private boolean hotScanFinished = false;
    private WScan hotScan = null;
    private WScan coldScan = null;
    private int offset;

    public HotColdMergeScanner(LindormWideColumnService wideColumnService, WScan wScan, String tableName, long boundaryTs) throws LindormException {
        super(wideColumnService, null, tableName);
        this.offset = wScan.getOffset();
        this.init(wScan, boundaryTs);
    }

    private void init(WScan wScan, long boundaryTs) throws LindormException {
        try {
            WTimeRange range = wScan.getTimeRange();
            this.hotScan = new WScan(wScan);
            this.hotScan.setTimeRange(boundaryTs, range.getMax());
            this.coldScan = new WScan(wScan);
            this.coldScan.setTimeRange(range.getMin(), boundaryTs);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    @Override
    public Iterator<WResult> iterator() {
        return new Iterator<WResult>(){
            WResult next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = HotColdMergeScanner.this.next();
                        return this.next != null;
                    }
                    catch (LindormException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public WResult next() {
                if (!this.hasNext()) {
                    return null;
                }
                WResult temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private WPartialResult doScan(WScan wScan) throws LindormException {
        WPartialResult result = this.wideColumnService.scan(this.tableName, wScan);
        if (result != null && result.getResults() != null) {
            this.cache.addAll(result.getResults());
        }
        if (result != null) {
            this.offset -= result.getSkipped();
        }
        return result;
    }

    private void loadFromHotData() throws LindormException {
        if (this.hotScanFinished) {
            return;
        }
        WPartialResult result = this.doScan(this.hotScan);
        if (result == null || result.getNextStartKey() == null) {
            this.hotScanFinished = true;
        } else {
            this.hotScan.setStartRowKey(result.getNextStartKey());
            this.hotScan.setResumeRow(result.getResumeRow());
            this.hotScan.setOffset(this.offset);
        }
    }

    private void loadFromColdData() throws LindormException {
        WPartialResult result = this.doScan(this.coldScan);
        if (result == null || result.getNextStartKey() == null) {
            this.needLoadingCache = false;
        } else {
            this.coldScan.setStartRowKey(result.getNextStartKey());
            this.coldScan.setResumeRow(result.getResumeRow());
            this.coldScan.setOffset(this.offset);
        }
    }

    private void loadCache() throws LindormException {
        this.loadFromHotData();
        if (this.hotScanFinished && this.cache.isEmpty()) {
            this.loadFromColdData();
        }
    }

    @Override
    public WResult next() throws LindormException {
        while (this.needLoadingCache && this.cache.size() == 0) {
            this.loadCache();
        }
        if (!this.cache.isEmpty()) {
            return this.cache.poll();
        }
        return null;
    }
}

