/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class SilenceRequestLimiter {
    private final double ratio;
    private int maxBuffered;
    private int majorRatio;
    private int minorRatio;
    private volatile long token;
    private volatile long count;
    public static final int REGULAR = 256;
    public static final int REGULAR_MASK = 255;
    public static final int MAJOR_REGULAR = 65536;
    public static final int MAJOR_REGULAR_MASK = 65535;
    public static final int SHIFT = 8;
    private static final AtomicLongFieldUpdater<SilenceRequestLimiter> countUpdater = AtomicLongFieldUpdater.newUpdater(SilenceRequestLimiter.class, "count");
    private static final AtomicLongFieldUpdater<SilenceRequestLimiter> tokenUpdater = AtomicLongFieldUpdater.newUpdater(SilenceRequestLimiter.class, "token");

    public SilenceRequestLimiter(double silenceRatio, int bufferedSilenceRequest) {
        if (silenceRatio < 0.0) {
            throw new IllegalArgumentException("SilenceRatio should be larger than 0");
        }
        if (bufferedSilenceRequest <= 0) {
            throw new IllegalArgumentException("bufferedSilenceRequest should be larger than 0");
        }
        this.ratio = silenceRatio;
        this.maxBuffered = bufferedSilenceRequest;
        this.token = bufferedSilenceRequest;
        this.majorRatio = (int)(this.ratio * 65536.0) >> 8;
        this.minorRatio = (int)(this.ratio * 65536.0) & 0xFF;
        this.majorRatio = this.normalize(this.majorRatio, 0, 256);
        this.minorRatio = this.normalize(this.minorRatio, 0, 256);
        this.maxBuffered = Math.max(this.majorRatio * 2, this.maxBuffered);
    }

    private int normalize(int num, int lowerBound, int upperBound) {
        return Math.max(Math.min(num, upperBound), lowerBound);
    }

    public void onRequest() {
        long num = countUpdater.incrementAndGet(this);
        if ((num & 0xFFL) == 0L) {
            int high = (int)(num & 0xFFFFL) >>> 8;
            int reverseHigh = Integer.reverse(high) >>> 24;
            int inc = this.majorRatio + (reverseHigh < this.minorRatio ? 1 : 0);
            if (this.token + (long)inc >= (long)this.maxBuffered) {
                tokenUpdater.set(this, this.maxBuffered);
            } else {
                tokenUpdater.addAndGet(this, inc);
            }
        }
    }

    public boolean shouldSilence() {
        long current;
        while ((current = this.token) > 0L) {
            if (!tokenUpdater.compareAndSet(this, current, current - 1L)) continue;
            return true;
        }
        return false;
    }

    public double getRatio() {
        return this.ratio;
    }

    public int getMaxBuffered() {
        return this.maxBuffered;
    }
}

