/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.ipc.Serializer;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ReflectionUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.HashMap;

public class WExec
extends VersionedObjectWithAttributes
implements OpTimeout {
    private Class protocol;
    private String protocolName;
    protected String methodName;
    protected Class[] parameterClasses;
    protected Object[] parameters;
    private LindormClientConfig config = new LindormClientConfig();
    private byte[] startKey;
    private byte[] stopKey;
    private int operationTimeout = -1;
    private int glitchTimeout = -1;
    private int rpcTimeout = -1;

    public WExec() {
    }

    public WExec(byte[] startKey, byte[] stopKey, Class protocol, Method method, Object[] parameters) {
        this.methodName = method.getName();
        this.parameterClasses = method.getParameterTypes();
        this.parameters = parameters;
        this.startKey = startKey;
        this.stopKey = stopKey;
        this.protocol = protocol;
        this.protocolName = protocol.getName();
    }

    public WExec(byte[] startKey, byte[] stopKey, String protocolName, String methodName, Class[] parameterClasses, Object[] parameters) {
        this.methodName = methodName;
        this.parameterClasses = parameterClasses;
        this.parameters = parameters;
        this.startKey = startKey;
        this.stopKey = stopKey;
        this.protocolName = protocolName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public Class getProtocol() {
        return this.protocol;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Serializer serializer = this.getSerializer();
        super.writeTo(out);
        out.writeUTF(this.methodName);
        out.writeInt(this.parameterClasses.length);
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            serializer.serialize(out, this.parameters[i], this.parameters[i] != null ? this.parameters[i].getClass() : this.parameterClasses[i]);
            out.writeUTF(this.parameterClasses[i].getName());
        }
        Bytes.writeByteArray(out, this.startKey);
        Bytes.writeByteArray(out, this.stopKey);
        out.writeUTF(this.protocolName);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        Serializer serializer = this.getSerializer();
        super.readFrom(in);
        this.methodName = in.readUTF();
        this.parameters = new Object[in.readInt()];
        this.parameterClasses = new Class[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = serializer.deserialize(in);
            String parameterClassName = in.readUTF();
            try {
                this.parameterClasses[i] = WExec.extendedForName(parameterClassName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Couldn't find class: " + parameterClassName);
            }
        }
        this.startKey = Bytes.readByteArray(in);
        this.stopKey = Bytes.readByteArray(in);
        this.protocolName = in.readUTF();
    }

    private Serializer getSerializer() {
        Class<?> serializerClass = this.config.getClass("lindorm.rpc.serializer.class", "com.alibaba.lindorm.server.client.WritableSerializer", LindormClientConstants.RPC_SERIALIZER_CLASS_DEFAULT);
        Serializer serializer = (Serializer)ReflectionUtils.newInstance(serializerClass);
        return serializer;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getStopKey() {
        return this.stopKey;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
    }

    @Override
    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    @Override
    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public static Class<?> extendedForName(String className) throws ClassNotFoundException {
        Class<Constable> valueType = className.equals("boolean") ? Boolean.TYPE : (className.equals("byte") ? Byte.TYPE : (className.equals("short") ? Short.TYPE : (className.equals("int") ? Integer.TYPE : (className.equals("long") ? Long.TYPE : (className.equals("float") ? Float.TYPE : (className.equals("double") ? Double.TYPE : (className.equals("char") ? Character.TYPE : Class.forName(className))))))));
        return valueType;
    }

    @Override
    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startKey", Bytes.toStringBinary(this.startKey));
        map.put("stopKey", Bytes.toStringBinary(this.stopKey));
        map.put("methodName", this.methodName);
        map.put("protocalName", this.protocolName);
        StringBuilder parameterClassSB = new StringBuilder();
        for (Class klass : this.parameterClasses) {
            parameterClassSB.append(klass.getCanonicalName() + ",");
        }
        parameterClassSB.setLength(parameterClassSB.length() - 1);
        map.put("parameterClass", parameterClassSB.toString());
        StringBuilder parametersSB = new StringBuilder();
        for (Object param : this.parameters) {
            parametersSB.append(param.toString() + ",");
        }
        parametersSB.setLength(parametersSB.length() - 1);
        map.put("parameters", parametersSB.toString());
        return ((Object)map).toString();
    }
}

