/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WTimeRange;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class WGet
extends VersionedObjectWithAttributes
implements OpTimeout {
    private byte[] rowKey = null;
    private long lockId = -1L;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private WFilter filter = null;
    private WTimeRange tr = new WTimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    int operationTimeout = -1;
    int glitchTimeout = -1;
    int rpcTimeout = -1;

    public WGet() {
    }

    public WGet(byte[] rowKey) {
        this(rowKey, -1L);
    }

    public WGet(byte[] rowKey, long rowLock) {
        this.rowKey = rowKey;
        this.lockId = rowLock;
    }

    public WGet(WGet get2) throws IOException {
        this.rowKey = get2.getRowKey();
        this.lockId = get2.getLockId();
        this.maxVersions = get2.getMaxVersions();
        this.cacheBlocks = get2.getCacheBlocks();
        this.filter = get2.getFilter();
        WTimeRange ctr = get2.getTimeRange();
        this.tr = new WTimeRange(ctr.getMin(), ctr.getMax());
        this.operationTimeout = get2.getOperationTimeout();
        this.glitchTimeout = get2.getGlitchTimeout();
        Map<byte[], NavigableSet<byte[]>> fams = get2.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : get2.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    public WGet addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public WGet addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public WGet setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new WTimeRange(minStamp, maxStamp);
        return this;
    }

    public WGet setTimeStamp(long timestamp) {
        try {
            this.tr = new WTimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public WGet setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public WGet setMaxVersions(int maxVersions) throws IOException {
        if (maxVersions <= 0) {
            throw new IOException("maxVersions must be positive");
        }
        this.maxVersions = maxVersions;
        return this;
    }

    public WGet setFilter(WFilter filter) {
        this.filter = filter;
        return this;
    }

    public WFilter getFilter() {
        return this.filter;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public long getLockId() {
        return this.lockId;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public WTimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public byte[] getRowKey() {
        return this.rowKey;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public void setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.rowKey);
        WritableUtils.writeVLong(out, this.lockId);
        WritableUtils.writeVInt(out, this.maxVersions);
        out.writeBoolean(this.cacheBlocks);
        WFilter.write(out, this.filter);
        this.tr.writeTo(out);
        WritableUtils.writeVInt(out, this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet != null) {
                WritableUtils.writeVInt(out, columnSet.size());
                for (byte[] qualifier : columnSet) {
                    Bytes.writeByteArray(out, qualifier);
                }
                continue;
            }
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.rowKey = Bytes.readByteArray(in);
        this.lockId = WritableUtils.readVLong(in);
        this.maxVersions = WritableUtils.readVInt(in);
        this.cacheBlocks = in.readBoolean();
        this.filter = WFilter.read(in);
        this.tr = new WTimeRange();
        this.tr.readFrom(in);
        int numFamilies = WritableUtils.readVInt(in);
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = WritableUtils.readVInt(in);
            TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (int j = 0; j < numColumns; ++j) {
                byte[] qualifier = Bytes.readByteArray(in);
                set.add(qualifier);
            }
            this.familyMap.put(family, set);
        }
    }

    @Override
    public String toString() {
        return this.toStringWithLimitColumns(5);
    }

    public String toStringWithLimitColumns(int maxCols) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary(this.rowKey));
        if (this.maxVersions > 1) {
            map.put("maxVersions", this.maxVersions);
        }
        if (!this.cacheBlocks) {
            map.put("cacheBlocks", this.cacheBlocks);
        }
        if (!this.tr.containsAllTime()) {
            ArrayList<Long> timeRange = new ArrayList<Long>();
            timeRange.add(this.tr.getMin());
            timeRange.add(this.tr.getMax());
            map.put("timeRange", timeRange);
        }
        map.put("Attributes", this.attributesToString());
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary(entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary(column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        return ((Object)map).toString();
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }

    @Override
    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    @Override
    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public WGet setQueryHotOnly(Boolean hotOnly) {
        if (hotOnly == null) {
            this.removeAttribute("HOT_ONLY");
        } else {
            this.setAttribute("HOT_ONLY", Bytes.toBytes(hotOnly));
            this.removeAttribute("COLD_HOT_MERGE");
        }
        return this;
    }

    public boolean isQueryHotOnly() {
        byte[] value = this.getAttribute("HOT_ONLY");
        return value != null && Bytes.toBoolean(value);
    }

    public WGet setHotColdAutoMerge(Boolean autoMerge) {
        if (autoMerge == null) {
            this.removeAttribute("COLD_HOT_MERGE");
        } else {
            this.setAttribute("COLD_HOT_MERGE", Bytes.toBytes(autoMerge));
            this.removeAttribute("HOT_ONLY");
        }
        return this;
    }

    public boolean isHotColdAutoMerge() {
        byte[] value = this.getAttribute("COLD_HOT_MERGE");
        return value != null && Bytes.toBoolean(value);
    }

    public void setMustReturnKVForExistentRow(boolean value) {
        this.setAttribute("KV_EXISTENT_ROW", Bytes.toBytes(value));
    }

    public boolean mustReturnKVForExistentRow() {
        byte[] bytes = this.getAttribute("KV_EXISTENT_ROW");
        return bytes != null && Bytes.toBoolean(bytes);
    }
}

