/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.ipc.LindormRawObject;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WMutation;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WRowMutations
extends VersionedObjectWithAttributes
implements OpTimeout {
    private byte[] row;
    private List<WMutation> mutations = new ArrayList<WMutation>();
    private int operationTimeout = -1;
    private int glitchTimeout = -1;
    private int rpcTimeout = -1;

    public WRowMutations() {
    }

    public WRowMutations(byte[] row) {
        this.row = row;
    }

    public void add(WPut put2) throws IOException {
        this.internalAdd(put2);
    }

    public void add(WDelete delete) throws IOException {
        this.internalAdd(delete);
    }

    private void internalAdd(WMutation mutation) throws IOException {
        int res = Bytes.compareTo(this.row, mutation.getRowKey());
        if (res != 0) {
            throw new IOException("The row in the recently added Put/Delete " + Bytes.toStringBinary(mutation.getRowKey()) + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        this.mutations.add(mutation);
    }

    public byte[] getRowKey() {
        return this.row;
    }

    public List<WMutation> getMutations() {
        return this.mutations;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }

    @Override
    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    @Override
    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.row);
        WritableUtils.writeVInt(out, this.mutations.size());
        for (WMutation mutation : this.mutations) {
            LindormRawObject.writeObject(out, mutation, mutation.getClass());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.row = Bytes.readByteArray(in);
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            this.mutations.add((WMutation)LindormRawObject.readObject(in, null));
        }
    }
}

