/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WColumnPaginationFilter
extends WFilter {
    private int limit = 0;
    private int offset = 0;

    public WColumnPaginationFilter() {
    }

    public WColumnPaginationFilter(int limit, int offset) {
        Preconditions.checkArgument(limit >= 0, "limit must be positive %s", limit);
        Preconditions.checkArgument(offset >= 0, "offset must be positive %s", offset);
        this.limit = limit;
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String toString() {
        return String.format("%s (%d, %d)", this.getClass().getSimpleName(), this.limit, this.offset);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.limit);
        WritableUtils.writeVInt(out, this.offset);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.limit = WritableUtils.readVInt(in);
        this.offset = WritableUtils.readVInt(in);
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WColumnPaginationFilter;
    }
}

