/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WFilterList
extends WFilter {
    private static final int MAX_LOG_FILTERS = 5;
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<WFilter> filters = new ArrayList<WFilter>();

    public WFilterList() {
    }

    public WFilterList(List<WFilter> rowFilters) {
        this.filters = rowFilters;
    }

    public WFilterList(WFilter ... rowFilters) {
        this.filters.addAll(Arrays.asList(rowFilters));
    }

    public WFilterList(Operator operator) {
        this.operator = operator;
    }

    public WFilterList(Operator operator, List<WFilter> rowFilters) {
        this.filters = rowFilters;
        this.operator = operator;
    }

    public WFilterList(Operator operator, WFilter ... rowFilters) {
        this.filters = Arrays.asList(rowFilters);
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<WFilter> getFilters() {
        return this.filters;
    }

    public void addFilter(WFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.operator.ordinal());
        out.writeInt(this.filters.size());
        for (WFilter filter : this.filters) {
            WFilter.write(out, filter);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        byte opByte = in.readByte();
        this.operator = Operator.values()[opByte];
        int size = in.readInt();
        if (size > 0) {
            this.filters = new ArrayList<WFilter>(size);
            for (int i = 0; i < size; ++i) {
                WFilter filter = WFilter.read(in);
                this.filters.add(filter);
            }
        }
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WFilterList;
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxFilters) {
        int endIndex = this.filters.size() < maxFilters ? this.filters.size() : maxFilters;
        return String.format("%s %s (%d/%d): %s", this.getClass().getSimpleName(), this.operator == Operator.MUST_PASS_ALL ? "AND" : "OR", endIndex, this.filters.size(), this.filters.subList(0, endIndex).toString());
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

