/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WFuzzyRowFilter
extends WFilter {
    private List<Pair<byte[], byte[]>> fuzzyKeysData;

    public WFuzzyRowFilter() {
    }

    public WFuzzyRowFilter(List<Pair<byte[], byte[]>> fuzzyKeysData) {
        this.fuzzyKeysData = fuzzyKeysData;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.fuzzyKeysData.size());
        for (Pair<byte[], byte[]> fuzzyData : this.fuzzyKeysData) {
            Bytes.writeByteArray(out, fuzzyData.getFirst());
            Bytes.writeByteArray(out, fuzzyData.getSecond());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int count = WritableUtils.readVInt(in);
        this.fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
        for (int i = 0; i < count; ++i) {
            byte[] keyBytes = Bytes.readByteArray(in);
            byte[] keyMeta = Bytes.readByteArray(in);
            this.fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
        }
    }

    public List<Pair<byte[], byte[]>> getFuzzyKeysData() {
        return this.fuzzyKeysData;
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WFuzzyRowFilter;
    }

    @Override
    public String toString() {
        if (this.fuzzyKeysData == null) {
            return this.getClass().getSimpleName() + " null";
        }
        return this.toString(5);
    }

    private String toString(int maxFuzzyKeyData) {
        int count = 0;
        StringBuilder ret = new StringBuilder();
        for (Pair<byte[], byte[]> entry : this.fuzzyKeysData) {
            if (++count > maxFuzzyKeyData) break;
            ret.append("[" + Bytes.toStringBinary(entry.getFirst()) + "," + Bytes.toStringBinary(entry.getSecond()) + "]");
            if (count >= maxFuzzyKeyData || count >= this.fuzzyKeysData.size()) continue;
            ret.append(",");
        }
        if (count < this.fuzzyKeysData.size()) {
            ret.append("...");
        }
        return this.getClass().getSimpleName() + " (" + count + "/" + this.fuzzyKeysData.size() + "): [" + ret.toString() + "]";
    }
}

