/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WParseFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRegexStringComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSubstringComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class WSingleColumnValueFilter
extends WFilter {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    private WCompareFilter.CompareOp compareOp;
    private WByteArrayComparable comparator;
    private boolean filterIfMissing = false;
    private boolean latestVersionOnly = true;

    public WSingleColumnValueFilter() {
    }

    public WSingleColumnValueFilter(byte[] family, byte[] qualifier, WCompareFilter.CompareOp compareOp, byte[] value) {
        this(family, qualifier, compareOp, new WBinaryComparator(value));
    }

    public WSingleColumnValueFilter(byte[] family, byte[] qualifier, WCompareFilter.CompareOp compareOp, WByteArrayComparable comparator) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    public WCompareFilter.CompareOp getOperator() {
        return this.compareOp;
    }

    public WByteArrayComparable getComparator() {
        return this.comparator;
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    public boolean getFilterIfMissing() {
        return this.filterIfMissing;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    public boolean getLatestVersionOnly() {
        return this.latestVersionOnly;
    }

    public void setLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
    }

    public static WFilter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 4 || filterArguments.size() == 6, "Expected 4 or 6 but got: %s", filterArguments.size());
        byte[] family = WParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        byte[] qualifier = WParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
        WCompareFilter.CompareOp compareOp = WParseFilter.createCompareOp(filterArguments.get(2));
        WByteArrayComparable comparator = WParseFilter.createComparator(WParseFilter.removeQuotesFromByteArray(filterArguments.get(3)));
        if ((comparator instanceof WRegexStringComparator || comparator instanceof WSubstringComparator) && compareOp != WCompareFilter.CompareOp.EQUAL && compareOp != WCompareFilter.CompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        WSingleColumnValueFilter filter = new WSingleColumnValueFilter(family, qualifier, compareOp, comparator);
        if (filterArguments.size() == 6) {
            boolean filterIfMissing = WParseFilter.convertByteArrayToBoolean(filterArguments.get(4));
            boolean latestVersionOnly = WParseFilter.convertByteArrayToBoolean(filterArguments.get(5));
            filter.setFilterIfMissing(filterIfMissing);
            filter.setLatestVersionOnly(latestVersionOnly);
        }
        return filter;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        out.writeUTF(this.compareOp.name());
        WByteArrayComparable.write(out, this.comparator);
        out.writeBoolean(this.filterIfMissing);
        out.writeBoolean(this.latestVersionOnly);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnFamily = Bytes.readByteArray(in);
        if (this.columnFamily.length == 0) {
            this.columnFamily = null;
        }
        this.columnQualifier = Bytes.readByteArray(in);
        if (this.columnQualifier.length == 0) {
            this.columnQualifier = null;
        }
        this.compareOp = WCompareFilter.CompareOp.valueOf(in.readUTF());
        this.comparator = WByteArrayComparable.read(in);
        this.filterIfMissing = in.readBoolean();
        this.latestVersionOnly = in.readBoolean();
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WSingleColumnValueFilter;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getSimpleName());
        ret.append(" (");
        ret.append(Bytes.toStringBinary(this.columnFamily));
        ret.append(":");
        ret.append(Bytes.toStringBinary(this.columnQualifier));
        ret.append(WCompareFilter.getReadableOperator(this.compareOp));
        ret.append(Bytes.toStringBinary(this.comparator.getValue()));
        ret.append(")");
        return ret.toString();
    }
}

