/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WTimestampsFilter
extends WFilter {
    private List<Long> timestamps;
    private static final int MAX_LOG_TIMESTAMPS = 5;

    public WTimestampsFilter() {
    }

    public WTimestampsFilter(List<Long> timestamps) {
        for (Long timestamp : timestamps) {
            Preconditions.checkArgument(timestamp >= 0L, "must be positive %s", timestamp);
        }
        this.timestamps = timestamps;
    }

    public List<Long> getTimestamps() {
        ArrayList<Long> list = new ArrayList<Long>(this.timestamps.size());
        list.addAll(this.timestamps);
        return list;
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxTimestamps) {
        StringBuilder tsList = new StringBuilder();
        int count = 0;
        for (Long ts : this.timestamps) {
            if (count >= maxTimestamps) break;
            tsList.append(ts.toString());
            if (++count >= this.timestamps.size() || count >= maxTimestamps) continue;
            tsList.append(", ");
        }
        return String.format("%s (%d/%d): [%s]", this.getClass().getSimpleName(), count, this.timestamps.size(), tsList.toString());
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        int numTimestamps = this.timestamps.size();
        WritableUtils.writeVInt(out, numTimestamps);
        for (Long timestamp : this.timestamps) {
            WritableUtils.writeVLong(out, timestamp);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int numTimestamps = WritableUtils.readVInt(in);
        this.timestamps = new ArrayList<Long>();
        for (int idx = 0; idx < numTimestamps; ++idx) {
            this.timestamps.add(WritableUtils.readVLong(in));
        }
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WTimestampsFilter;
    }
}

