/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.tableservice.LSelect;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Select;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PagingContext {
    private final LQueryResults.SelectContext context;
    private final LSelect lastSelect;

    public PagingContext(LQueryResults.SelectContext context, LSelect lastSelect) {
        this.context = context;
        this.lastSelect = lastSelect;
    }

    public PagingContext(byte[] bytes) throws LindormException {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(stream);
        try {
            int payloadLength = WritableUtils.readVInt(in);
            byte[] contextBytes = new byte[payloadLength];
            in.readFully(contextBytes);
            this.context = new LQueryResults.SelectContext();
            this.context.readFrom(new DataInputStream(new ByteArrayInputStream(contextBytes)));
            int lastSelectLength = WritableUtils.readVInt(in);
            byte[] lastSelectBytes = new byte[lastSelectLength];
            in.readFully(lastSelectBytes);
            this.lastSelect = new LSelect();
            this.lastSelect.readFrom(new DataInputStream(new ByteArrayInputStream(lastSelectBytes)));
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public byte[] serialize() throws LindormException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        try {
            ByteArrayOutputStream stream1 = new ByteArrayOutputStream();
            DataOutputStream out1 = new DataOutputStream(stream1);
            this.context.writeTo(out1);
            byte[] contextBytes = stream1.toByteArray();
            WritableUtils.writeVInt(out, contextBytes.length);
            stream.write(contextBytes);
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            DataOutputStream out2 = new DataOutputStream(stream2);
            this.lastSelect.writeTo(out2);
            byte[] selectBytes = stream2.toByteArray();
            WritableUtils.writeVInt(out, selectBytes.length);
            stream.write(selectBytes);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public LQueryResults.SelectContext getContext() {
        return this.context;
    }

    public Select getLastSelect() {
        return this.lastSelect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagingContext that = (PagingContext)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        return this.lastSelect != null ? this.lastSelect.equals(that.lastSelect) : that.lastSelect == null;
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + (this.lastSelect != null ? this.lastSelect.hashCode() : 0);
        return result;
    }
}

