/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.quota;

public enum QuotaOpType {
    READ("r", 1),
    WRITE("w", 2),
    MIX("m", 3),
    DDL("d", 3);

    private String name;
    private byte code;

    private QuotaOpType(String shortName, byte code) {
        this.name = shortName;
        this.code = code;
    }

    public String shortName() {
        return this.name;
    }

    public byte getCode() {
        return this.code;
    }

    public static QuotaOpType parseFromShortName(String name) {
        if (name.equals(READ.shortName())) {
            return READ;
        }
        if (name.equals(WRITE.shortName())) {
            return WRITE;
        }
        if (name.equals(MIX.shortName())) {
            return MIX;
        }
        if (name.equals(DDL.shortName())) {
            return DDL;
        }
        throw new IllegalArgumentException();
    }

    public static QuotaOpType parseFromByte(byte code) {
        switch (code) {
            case 1: {
                return READ;
            }
            case 2: {
                return WRITE;
            }
            case 3: {
                return MIX;
            }
            case 4: {
                return DDL;
            }
        }
        throw new IllegalArgumentException();
    }
}

