/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AccumulatorColumnSchema
extends VersionedObjectWithAttributes {
    public static final String ACCUMULATOR_COLUMN_SCHEMA = "ACCUMULATOR_COLUMN_SCHEMA";
    public static final byte[] ACCUMULATOR_COLUMN_SCHEMA_KEY_BYTES = Bytes.toBytes("ACCUMULATOR_COLUMN_SCHEMA");
    private List<LColumn> columnList = null;

    public AccumulatorColumnSchema() {
    }

    public AccumulatorColumnSchema(TableMeta table) {
        this.columnList = new ArrayList<LColumn>();
        for (LColumn column : table.getNonPkColumns()) {
            if (!SchemaUtils.isAccumulatorType(column.getDataType())) continue;
            this.columnList.add(column);
        }
    }

    public List<LColumn> getColumns() {
        return this.columnList;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.columnList != null && this.columnList.size() > 0) {
            Bytes.writeByteArray(out, SchemaUtils.columnSchemasToBytes(this.columnList));
        } else {
            Bytes.writeByteArray(out, null);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        byte[] columnListBytes = Bytes.readByteArrayNullable(in);
        if (columnListBytes != null) {
            this.columnList = SchemaUtils.bytesToColumnSchemas(columnListBytes);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public byte[] getBytes() {
        try {
            return LindormObjectUtils.getBytes(this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void fromBytes(byte[] bytes) {
        try {
            LindormObjectUtils.getWritable(bytes, this);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

