/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.DataType;
import java.util.concurrent.TimeUnit;

public class CHSColumnSchema {
    private byte[] column;
    private LColumn lcolumn;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    public static final String EXAMPLE = "Example:COLUMN=column|POLICY=com.alibaba.lindorm.server.ldserver.chspolicy.CHSColumnPolicy|TIMEUNIT=NANOSECONDS or COLUMN=column|TIMEUNIT=NANOSECONDS or COLUMN=column";
    public static final String DELIMETER = "\\|";

    public CHSColumnSchema() {
    }

    public CHSColumnSchema(byte[] column) {
        this.column = column;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public LColumn getLcolumn() {
        return this.lcolumn;
    }

    public void setLcolumn(LColumn lcolumn) {
        this.lcolumn = lcolumn;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("COLUMN=");
        sb.append(Bytes.toString(this.column));
        if (this.timeUnit != TimeUnit.MILLISECONDS) {
            sb.append(", TimeUnit=" + (Object)((Object)this.timeUnit));
        }
        return sb.toString();
    }

    public static CHSColumnSchema fromString(String schema) {
        if (StringUtils.isNullOrEmpty(schema)) {
            throw new IllegalArgumentException("Invalid CHS config " + schema + EXAMPLE);
        }
        String[] parts = schema.split(DELIMETER);
        if (parts.length > 3) {
            throw new IllegalArgumentException("Invalid CHS config " + schema + EXAMPLE);
        }
        CHSColumnSchema chsColumnSchema = new CHSColumnSchema();
        boolean columnAlreadySet = false;
        for (String configParts : parts) {
            String[] configPart = configParts.split("=");
            if (configPart.length != 2) {
                throw new IllegalArgumentException("Invalid CHS config " + schema + EXAMPLE);
            }
            if (configPart[0].toUpperCase().equals("COLUMN")) {
                columnAlreadySet = true;
                chsColumnSchema.setColumn(Bytes.toBytes(configPart[1]));
                continue;
            }
            if (!configPart[0].toUpperCase().equals("TIMEUNIT")) continue;
            TimeUnit timeUnit = TimeUnit.valueOf(configPart[1]);
            chsColumnSchema.setTimeUnit(timeUnit);
        }
        if (!columnAlreadySet) {
            throw new IllegalArgumentException("Invalid CHS config " + schema + EXAMPLE);
        }
        return chsColumnSchema;
    }

    public static void validateCHSColumnSchema(TableMeta tableMeta) throws IllegalRequestException {
        String columnAndPolicy = tableMeta.getFamilyAttributes().getChsColumn();
        if (columnAndPolicy == null) {
            return;
        }
        CHSColumnSchema schema = CHSColumnSchema.fromString(columnAndPolicy);
        if (schema != null) {
            if (tableMeta.getFamilies().size() > 1) {
                throw new IllegalRequestException("Default CHS Schema can only be set on Single family table");
            }
            if (tableMeta.getFamilies().isEmpty()) {
                CHSColumnSchema.verify(tableMeta, SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, schema);
            } else {
                CHSColumnSchema.verify(tableMeta, tableMeta.getFamilies().get(0).getName(), schema);
            }
        }
        for (ColumnFamilyDescriptor descriptor : tableMeta.getFamilies()) {
            FamilyAttributes colAttributes = descriptor.getFamilyAttributes();
            String columnAndPolicyFromFamily = colAttributes.getChsColumn();
            if (columnAndPolicyFromFamily == null) {
                return;
            }
            schema = CHSColumnSchema.fromString(columnAndPolicy);
            if (schema == null) continue;
            CHSColumnSchema.verify(tableMeta, descriptor.getName(), schema);
        }
    }

    private static void verify(TableMeta meta, byte[] familyName, CHSColumnSchema schema) throws IllegalRequestException {
        if (schema.getColumn() == null) {
            throw new IllegalRequestException("Must explicitly specify column name for CHS_COLUMN");
        }
        for (LColumn lcolumn : meta.getAllColumns()) {
            if (lcolumn.getFamilyName() == null) {
                if (!Bytes.equals(lcolumn.getColumnName(), schema.getColumn()) || !Bytes.equals(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, familyName)) continue;
                if (lcolumn.getDataType().getClientType() == DataType.INT || lcolumn.getDataType().getClientType() == DataType.LONG) break;
                throw new IllegalRequestException("CHS column must be Int or Long type");
            }
            if (!Bytes.equals(lcolumn.getColumnName(), schema.getColumn()) || !Bytes.equals(lcolumn.getFamilyName(), familyName)) continue;
            if (lcolumn.getDataType().getClientType() == DataType.INT || lcolumn.getDataType().getClientType() == DataType.LONG) break;
            throw new IllegalRequestException("CHS column must be Int or Long type");
        }
    }
}

