/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.ColumnSchemaOption;
import com.alibaba.lindorm.client.schema.DataType;

public class ColumnSchema
implements Comparable<ColumnSchema> {
    private byte[] familyName;
    private byte[] columnName;
    private DataType type;
    private CollectionDataType collectionDataType;
    private Integer maxLength = null;
    private Integer scale = null;
    private ColumnSchemaOption option = null;

    public ColumnSchema() {
    }

    public ColumnSchema(byte[] columnName, DataType type) {
        this(null, columnName, type);
    }

    public ColumnSchema(byte[] columnName, DataType type, ColumnSchemaOption columnSchemaOption) {
        this(null, columnName, type);
        this.option = columnSchemaOption;
    }

    public ColumnSchema(byte[] columnName, CollectionDataType type) {
        this(null, columnName, type.getDataTypeEnum(), type);
    }

    public ColumnSchema(byte[] columnName, DataType type, int maxLength) {
        this(null, columnName, type, maxLength);
    }

    public ColumnSchema(byte[] columnName, DataType type, int precision, int scale) {
        this(null, columnName, type, precision, scale);
    }

    public ColumnSchema(String columnName, DataType type) {
        this(null, Bytes.toBytes(columnName), type);
    }

    public ColumnSchema(String columnName, DataType type, ColumnSchemaOption columnSchemaOption) {
        this(Bytes.toBytes(columnName), type);
        this.option = columnSchemaOption;
    }

    public ColumnSchema(String columnName, CollectionDataType collectionDataType) {
        this(null, Bytes.toBytes(columnName), collectionDataType.getDataTypeEnum(), collectionDataType);
    }

    public ColumnSchema(String columnName, DataType type, int length) {
        this(null, Bytes.toBytes(columnName), type, length);
    }

    public ColumnSchema(String columnName, DataType type, int precision, int scale) {
        this(null, Bytes.toBytes(columnName), type, precision, scale);
    }

    public ColumnSchema(String familyName, String columnName, DataType type) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type);
    }

    public ColumnSchema(String familyName, String columnName, DataType type, ColumnSchemaOption columnSchemaOption) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type);
        this.option = columnSchemaOption;
    }

    public ColumnSchema(String familyName, String columnName, DataType type, int length) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type, length);
    }

    public ColumnSchema(String familyName, String columnName, DataType type, int precision, int scale) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), type, precision, scale);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type) {
        this(familyName, columnName, type, null);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type, CollectionDataType collectionDataType) {
        this.setFamilyName(familyName);
        this.setColumnName(columnName);
        this.setDataType(type, collectionDataType);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type, int maxLength) {
        if (type != DataType.BINARY && type != DataType.CHAR) {
            throw new IllegalArgumentException("Only DataType#BINARY and DataType#CHAR type support this constructor.");
        }
        this.setFamilyName(familyName);
        this.setColumnName(columnName);
        this.setDataType(type, maxLength);
    }

    public ColumnSchema(byte[] familyName, byte[] columnName, DataType type, int precision, int scale) {
        if (type != DataType.DECIMAL) {
            throw new IllegalArgumentException("Only DataType#DECIMAL type supports this constructor.");
        }
        this.setFamilyName(familyName);
        this.setColumnName(columnName);
        this.setDataType(type, precision, scale);
    }

    public void setFamilyName(byte[] familyName) {
        this.familyName = (byte[])(familyName == null || familyName.length == 0 ? null : familyName);
    }

    public void setFamilyName(String familyName) {
        this.setFamilyName(Bytes.toBytes(familyName));
    }

    public byte[] getFamilyName() {
        return this.familyName;
    }

    public String getFamilyNameAsString() {
        return Bytes.toString(this.familyName);
    }

    public void setColumnName(byte[] columnName) {
        if (columnName == null || columnName.length == 0) {
            throw new IllegalArgumentException("Column name must not be null or empty.");
        }
        this.columnName = columnName;
    }

    public void setColumnName(String columnName) {
        this.setColumnName(Bytes.toBytes(columnName));
    }

    public byte[] getColumnName() {
        return this.columnName;
    }

    public String getColumnNameAsString() {
        return Bytes.toString(this.columnName);
    }

    public void setDataType(DataType type) {
        this.setDataType(type, null);
    }

    public void setDataType(DataType type, CollectionDataType collectionDataType) {
        if (type == null) {
            throw new IllegalArgumentException("Column data type must not be null.");
        }
        if (DataTypeUtils.needLength(type)) {
            throw new IllegalArgumentException("You must specify length for type " + (Object)((Object)type));
        }
        if (type.isCollection() && collectionDataType == null) {
            throw new IllegalArgumentException("collectionDataType is null.");
        }
        if (collectionDataType != null && collectionDataType.getDataTypeEnum() != type) {
            throw new IllegalArgumentException("dataType is " + (Object)((Object)type) + " but collectionDataType is " + collectionDataType);
        }
        this.type = type;
        this.collectionDataType = collectionDataType;
    }

    public void setDataType(DataType type, int maxLength) {
        if (type != DataType.BINARY && type != DataType.CHAR) {
            throw new IllegalArgumentException("You cannot specify length for type " + (Object)((Object)type));
        }
        DataTypeUtils.validateLength(maxLength);
        this.type = type;
        this.maxLength = maxLength;
    }

    public void setDataType(DataType type, int precision, int scale) {
        if (type != DataType.DECIMAL) {
            throw new IllegalArgumentException("You cannot specify length for type " + (Object)((Object)type));
        }
        DataTypeUtils.validatePrecisionAndScale(precision, scale);
        this.type = type;
        this.maxLength = precision;
        this.scale = scale;
    }

    public void setColumnSchemaOption(ColumnSchemaOption option) {
        this.option = option;
    }

    public boolean isIdempotentIdColumn() {
        return this.option == ColumnSchemaOption.IDEMPOTENT;
    }

    public DataType getDataType() {
        return this.type;
    }

    public CollectionDataType getCollectionDataType() {
        return this.collectionDataType;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public ColumnSchemaOption getColumnSchemaOption() {
        return this.option;
    }

    public String toString() {
        return SchemaUtils.getFullColumnName(this.familyName, this.columnName) + " " + this.type.toString() + DataTypeUtils.lengthToString(this.maxLength, this.scale) + (this.option == null ? "" : " " + (Object)((Object)this.option));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnSchema)) {
            return false;
        }
        return this.compareTo((ColumnSchema)obj) == 0;
    }

    @Override
    public int compareTo(ColumnSchema other) {
        int result = Bytes.compareTo(this.familyName, other.familyName);
        if (result == 0) {
            result = Bytes.compareTo(this.columnName, other.columnName);
        }
        if (result == 0) {
            result = this.type == null ? (other.type == null ? 0 : -1) : this.type.compareTo(other.type);
        }
        if (result == 0) {
            result = this.collectionDataType == null ? (other.collectionDataType == null ? 0 : -1) : this.collectionDataType.compareTo(other.collectionDataType);
        }
        return result;
    }
}

