/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CreateEntityOptions
extends VersionedObjectWithAttributes {
    private boolean onlyOneBuildingEntity = false;
    private boolean inheritSplits = true;
    private byte[][] splits = null;

    public boolean isInheritSplits() {
        return this.inheritSplits;
    }

    public void setInheritSplits(boolean inheritSplits) {
        this.inheritSplits = inheritSplits;
    }

    public byte[][] getSplits() {
        return this.splits;
    }

    public void setSplits(byte[][] splits) {
        this.splits = splits;
    }

    public boolean isOnlyOneBuildingEntity() {
        return this.onlyOneBuildingEntity;
    }

    public void setOnlyOneBuildingEntity(boolean onlyOneBuildingEntity) {
        this.onlyOneBuildingEntity = onlyOneBuildingEntity;
    }

    public void validate() throws IllegalRequestException {
        if (this.inheritSplits && this.splits != null) {
            throw new IllegalRequestException("Should not set user-defined splits while inheritSplits is true.");
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        out.writeBoolean(this.onlyOneBuildingEntity);
        out.writeBoolean(this.inheritSplits);
        if (this.splits != null) {
            WritableUtils.writeVInt(out, this.splits.length);
            for (byte[] key : this.splits) {
                Bytes.writeByteArray(out, key);
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.onlyOneBuildingEntity = in.readBoolean();
        this.inheritSplits = in.readBoolean();
        int splitsLength = WritableUtils.readVInt(in);
        if (splitsLength > 0) {
            this.splits = new byte[splitsLength][];
            for (int i = 0; i < splitsLength; ++i) {
                this.splits[i] = Bytes.readByteArray(in);
            }
        } else {
            this.splits = null;
        }
        this.initFromAttributes();
    }

    private void setupAttributes() throws IOException {
    }

    private void initFromAttributes() throws IOException {
    }
}

