/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.expression.FunctionCall;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.SortOrder;

public class IndexedColumnSchema {
    private ColumnKey columnKey;
    private SortOrder sortOrder;
    private PrimaryKeyOption option = null;
    private FunctionCall function = null;

    public IndexedColumnSchema(String columnName) {
        this(null, Bytes.toBytes(columnName), SortOrder.getDefault());
    }

    public IndexedColumnSchema(FunctionCall function) {
        this(function.getName() + function.getArguments(), SortOrder.getDefault());
        this.function = function;
    }

    public IndexedColumnSchema(String columnName, SortOrder sortOrder) {
        this(null, Bytes.toBytes(columnName), sortOrder);
    }

    public IndexedColumnSchema(byte[] columnName) {
        this(null, columnName, SortOrder.getDefault());
    }

    public IndexedColumnSchema(byte[] columnName, SortOrder sortOrder) {
        this(null, columnName, sortOrder);
    }

    public IndexedColumnSchema(String familyName, String columnName) {
        this(familyName, columnName, SortOrder.getDefault());
    }

    public IndexedColumnSchema(String familyName, String columnName, SortOrder sortOrder) {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), sortOrder);
    }

    public IndexedColumnSchema(byte[] familyName, byte[] columnName) {
        this(familyName, columnName, SortOrder.getDefault());
    }

    public IndexedColumnSchema(byte[] familyName, byte[] columnName, SortOrder sortOrder) {
        this(new ColumnKey(familyName, columnName), sortOrder);
    }

    public IndexedColumnSchema(ColumnKey columnKey, SortOrder sortOrder) {
        this.columnKey = columnKey;
        this.sortOrder = sortOrder;
    }

    public IndexedColumnSchema(ColumnKey columnKey, SortOrder sortOrder, PrimaryKeyOption option) {
        this.columnKey = columnKey;
        this.sortOrder = sortOrder;
        this.option = option;
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Deprecated
    public void setHashed(boolean hashed) {
        this.option = hashed ? PrimaryKeyOption.HASHED : null;
    }

    @Deprecated
    public boolean isHashed() {
        return this.option == PrimaryKeyOption.HASHED;
    }

    public void setPkOption(PrimaryKeyOption option) {
        this.option = option;
    }

    public PrimaryKeyOption getPkOption() {
        return this.option;
    }

    public FunctionCall getColumnFunction() {
        return this.function;
    }

    public boolean isFunctionColumn() {
        return this.function != null;
    }

    public void setColumnFunction(FunctionCall call) {
        this.function = call;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.sortOrder == SortOrder.getDefault()) {
            str.append(this.columnKey.toString());
        } else {
            str.append(this.columnKey + " " + (Object)((Object)this.sortOrder));
        }
        str.append(this.option == null ? "" : " " + this.option.toString());
        return str.toString();
    }
}

