/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

public class LindormAttribute
extends VersionedObjectWithAttributes {
    private String name;
    private String value;
    private String comment;

    public LindormAttribute() {
    }

    public LindormAttribute(String name, String value) throws IllegalRequestException {
        this(name, value, null);
    }

    public LindormAttribute(String name, String value, String comment) throws IllegalRequestException {
        SchemaUtils.checkNullOrEmpty(name, "Attribute name");
        this.name = name;
        this.value = value;
        if (comment != null && comment.length() > 256) {
            throw new IllegalRequestException("Too long comment for attribute (" + name + ", " + value + "), max size is " + 256 + ", but has " + comment.length());
        }
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.name);
        WritableUtils.writeString(out, this.value);
        WritableUtils.writeString(out, this.comment);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.name = WritableUtils.readString(in);
        this.value = WritableUtils.readString(in);
        this.comment = WritableUtils.readString(in);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LindormAttribute)) {
            return false;
        }
        LindormAttribute other = (LindormAttribute)obj;
        return this.name.equals(other.name);
    }

    @Override
    public String toString() {
        return "(" + this.name + "=" + this.value + ")";
    }

    public static void checkDuplicateAttributes(List<LindormAttribute> attrs) throws IllegalRequestException {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        HashSet<LindormAttribute> tmp = new HashSet<LindormAttribute>();
        for (LindormAttribute attr : attrs) {
            if (tmp.add(attr)) continue;
            throw new IllegalRequestException("Found duplicate attribute name : " + attr.getName());
        }
    }
}

