/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.LindormAttribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LindormFamilyAttributes
extends VersionedObjectWithAttributes {
    private String familyName;
    private List<LindormAttribute> attrs;

    public LindormFamilyAttributes() {
    }

    public LindormFamilyAttributes(String familyName, List<LindormAttribute> attrs) throws IllegalRequestException {
        SchemaUtils.checkNullOrEmpty(familyName, "Family name");
        SchemaUtils.checkNullOrEmpty(attrs, "Family attributes");
        this.familyName = familyName;
        this.attrs = attrs;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public List<LindormAttribute> getAttributes() {
        return this.attrs;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.familyName);
        WritableUtils.writeVInt(out, this.attrs.size());
        for (LindormAttribute attr : this.attrs) {
            attr.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.familyName = WritableUtils.readString(in);
        int attrSize = WritableUtils.readVInt(in);
        this.attrs = new ArrayList<LindormAttribute>(attrSize);
        for (int i = 0; i < attrSize; ++i) {
            LindormAttribute attr = new LindormAttribute();
            attr.readFrom(in);
            this.attrs.add(attr);
        }
    }

    public int hashCode() {
        return this.familyName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof LindormFamilyAttributes)) {
            return false;
        }
        LindormFamilyAttributes other = (LindormFamilyAttributes)obj;
        return this.familyName.equals(other.familyName);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.familyName);
        str.append("=");
        str.append(this.attrs.size());
        str.append("@(");
        for (LindormAttribute attr : this.attrs) {
            str.append(attr.toString());
            str.append(", ");
        }
        str.setLength(str.length() - 1);
        str.append(")]");
        return str.toString();
    }

    public static void checkDuplicateAttributes(List<LindormFamilyAttributes> attrs) throws IllegalRequestException {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        HashSet<LindormFamilyAttributes> tmp = new HashSet<LindormFamilyAttributes>();
        for (LindormFamilyAttributes attr : attrs) {
            if (tmp.add(attr)) continue;
            throw new IllegalRequestException("Found duplicate family attribute : " + attr.getFamilyName());
        }
    }
}

