/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.DescriptorAttributes;
import java.util.concurrent.TimeUnit;

public class LindormPipeDescriptor
extends DescriptorAttributes {
    private String pipeName = null;
    private boolean idempotentEnabled = false;
    private int TTL = Integer.MAX_VALUE;
    private int idempotentWindow = 86400;
    private ColumnFamilyDescriptor valueFamilyDescriptor = null;
    private ColumnFamilyDescriptor idempotentFamilyDescriptor = null;
    private ColumnFamilyDescriptor sequenceFamilyDescriptor = null;

    public LindormPipeDescriptor() {
        this.init();
    }

    public LindormPipeDescriptor(String name) {
        this.pipeName = name;
        this.init();
    }

    private void init() {
        this.tableAttributes.setConsistencyType(TableAttributes.ConsistencyType.Strong);
        ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(FeedStreamUtils.VALUE_FAMILY_NAME_BYTES);
        this.valueFamilyDescriptor = FeedStreamUtils.updateValueFamilyDescriptor(cfd);
        cfd = new ColumnFamilyDescriptor(FeedStreamUtils.SEQUENCE_FAMILY_NAME_BYTES);
        this.sequenceFamilyDescriptor = FeedStreamUtils.updateSequenceFamilyDescriptor(cfd);
        this.sequenceFamilyDescriptor.setTimeToLive(Integer.MAX_VALUE, TimeUnit.SECONDS);
        cfd = new ColumnFamilyDescriptor(FeedStreamUtils.IDEMPOTENT_FAMILY_NAME_BYTES);
        this.idempotentFamilyDescriptor = FeedStreamUtils.updateIdempotentFamilyDescriptor(cfd);
        this.idempotentFamilyDescriptor.setTimeToLive(this.idempotentWindow, TimeUnit.SECONDS);
    }

    public LindormPipeDescriptor setName(String name) {
        this.pipeName = name;
        return this;
    }

    public String getName() {
        return this.pipeName;
    }

    public LindormPipeDescriptor setIdempotentEnabled(boolean enabled) {
        this.idempotentEnabled = enabled;
        return this;
    }

    public boolean isIdempotentEnabled() {
        return this.idempotentEnabled;
    }

    public LindormPipeDescriptor setMessageTTL(int ttl) {
        if (ttl < 0) {
            throw new IllegalArgumentException("Pipe ttl should be grater than 0, can not be set to " + ttl);
        }
        if (ttl < this.idempotentWindow) {
            throw new IllegalArgumentException("Set TTL fail, Pipe TTL should not be less than than Idempotent window, ttl: " + ttl + " Idempotent window " + this.idempotentWindow);
        }
        this.TTL = ttl;
        this.valueFamilyDescriptor.setTimeToLive(ttl, TimeUnit.SECONDS);
        return this;
    }

    public int getMessageTTL() {
        return this.TTL;
    }

    public LindormPipeDescriptor setIdempotentWindow(int window) {
        if (window < 0) {
            throw new IllegalArgumentException("Failed to set idempotent window to " + window + " Idempotent window should " + "not be less than 0");
        }
        if (!this.idempotentEnabled) {
            throw new IllegalArgumentException("Pipe is not idempotent enabled, pipe name: " + this.pipeName);
        }
        if (window > this.TTL) {
            throw new IllegalArgumentException("Set idempotent window fail, Idempotent window should not be larger than than Pipe TTL, ttl: " + this.getMessageTTL() + "idempotent window:" + window);
        }
        this.idempotentWindow = window;
        this.idempotentFamilyDescriptor.setTimeToLive(window, TimeUnit.SECONDS);
        return this;
    }

    public int getIdempotentWindow() {
        return this.idempotentWindow;
    }

    public ColumnFamilyDescriptor getValueFamilyDescriptor() {
        return this.valueFamilyDescriptor;
    }

    public LindormPipeDescriptor setValueFamilyDescriptor(ColumnFamilyDescriptor cfd) throws IllegalRequestException {
        FeedStreamUtils.validateFamilyName(cfd.getNameAsString(), this.valueFamilyDescriptor.getNameAsString());
        this.valueFamilyDescriptor = FeedStreamUtils.updateValueFamilyDescriptor(cfd);
        if (cfd.getTimeToLive() < this.getIdempotentWindow()) {
            throw new IllegalRequestException("Value family ttl should not be less than idempotent window, value family ttl:" + cfd.getTimeToLive() + " idempotentWindow: " + this.getIdempotentWindow());
        }
        this.setMessageTTL(cfd.getTimeToLive());
        return this;
    }

    public ColumnFamilyDescriptor getIdempotentFamilyDescriptor() {
        return this.idempotentFamilyDescriptor;
    }

    public LindormPipeDescriptor setIdempotentFamilyDescriptor(ColumnFamilyDescriptor cfd) throws IllegalRequestException {
        if (!this.idempotentEnabled) {
            throw new IllegalRequestException("Idempotent is not set to enabled for pipe " + this.pipeName);
        }
        FeedStreamUtils.validateFamilyName(cfd.getNameAsString(), this.idempotentFamilyDescriptor.getNameAsString());
        this.idempotentFamilyDescriptor = FeedStreamUtils.updateIdempotentFamilyDescriptor(cfd);
        if (cfd.getTimeToLive() > this.getMessageTTL()) {
            throw new IllegalRequestException("Idempotent family ttl should not be greater than pipe ttl idemp ttl:" + cfd.getTimeToLive() + " pipe ttl: " + this.getMessageTTL());
        }
        this.idempotentFamilyDescriptor.setTimeToLive(cfd.getTimeToLive(), TimeUnit.SECONDS);
        this.idempotentWindow = cfd.getTimeToLive();
        return this;
    }

    public ColumnFamilyDescriptor getSequenceFamilyDescriptor() {
        return this.sequenceFamilyDescriptor;
    }

    public LindormPipeDescriptor setSequenceFamilyDescriptor(ColumnFamilyDescriptor cfd) throws IllegalRequestException {
        FeedStreamUtils.validateFamilyName(cfd.getNameAsString(), this.sequenceFamilyDescriptor.getNameAsString());
        this.sequenceFamilyDescriptor = FeedStreamUtils.updateSequenceFamilyDescriptor(cfd);
        this.sequenceFamilyDescriptor.setTimeToLive(Integer.MAX_VALUE, TimeUnit.SECONDS);
        return this;
    }

    @Override
    public void setFamilyAttributes(byte[] familyName, String name, String value) throws IllegalRequestException {
        ColumnFamilyDescriptor cfd = null;
        if (Bytes.equals(familyName, this.valueFamilyDescriptor.getName())) {
            cfd = this.valueFamilyDescriptor;
        } else if (Bytes.equals(familyName, this.sequenceFamilyDescriptor.getName())) {
            if (name.equals("TTL")) {
                throw new IllegalRequestException("FeedStream Pipe's Sequence family TTL is set to forever by default, and should not be modified");
            }
            cfd = this.sequenceFamilyDescriptor;
        } else if (Bytes.equals(familyName, this.idempotentFamilyDescriptor.getName())) {
            cfd = this.idempotentFamilyDescriptor;
            if (!this.idempotentEnabled) {
                throw new IllegalRequestException("Idempotent is not set to enabled for pipe " + this.pipeName);
            }
            if (name.equals("TTL") && Integer.parseInt(value) > this.getMessageTTL()) {
                throw new IllegalRequestException("Idempotent family ttl should not be greater than pipe ttl idemp ttl:" + cfd.getTimeToLive() + " pipe ttl: " + this.getMessageTTL());
            }
        }
        if (cfd == null) {
            throw new IllegalRequestException("Unknown family name " + Bytes.toStringBinary(familyName));
        }
        cfd.getFamilyAttributes().setAttribute(name, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LindormPipeDescriptor)) {
            return false;
        }
        String otherPipeName = ((LindormPipeDescriptor)obj).pipeName;
        return this.pipeName.equals(otherPipeName);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Pipe [");
        str.append(this.pipeName);
        str.append("], idempotent=");
        str.append(this.idempotentEnabled);
        str.append(", valueFamily=");
        str.append(this.valueFamilyDescriptor.toString());
        str.append(", sequenceFamily=");
        str.append(this.sequenceFamilyDescriptor.toString());
        if (this.idempotentEnabled) {
            str.append(", idempotentFamily=");
            str.append(this.idempotentFamilyDescriptor.toString());
        }
        str.append(", tableAttributes=");
        str.append(this.tableAttributes.toString());
        return str.toString();
    }
}

