/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;

public class ListType
extends CollectionDataType {
    private CollectionDataType collectionDataType;
    private DataType dataType;

    public ListType(DataType dataType) {
        super(3);
        this.dataType = dataType;
    }

    public ListType(CollectionDataType collectionDataType) {
        super(3);
        this.collectionDataType = collectionDataType;
    }

    @Override
    public DataType getDataTypeEnum() {
        return DataType.LIST;
    }

    public CollectionDataType getCollectionDataType() {
        return this.collectionDataType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int compareTo(CollectionDataType collectionDataType) {
        int result;
        if (collectionDataType == null) {
            return 1;
        }
        if (this.id == collectionDataType.id) {
            ListType other = (ListType)collectionDataType;
            result = this.compare(this.collectionDataType, this.dataType, other.collectionDataType, other.dataType);
        } else {
            result = this.id > collectionDataType.id ? 1 : -1;
        }
        return result;
    }

    public String toString() {
        return String.format("List<%s>", this.dataType != null ? this.dataType : this.collectionDataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListType listType = (ListType)o;
        if (this.collectionDataType != null ? !this.collectionDataType.equals(listType.collectionDataType) : listType.collectionDataType != null) {
            return false;
        }
        return this.dataType == listType.dataType;
    }

    public int hashCode() {
        int result = this.collectionDataType != null ? this.collectionDataType.hashCode() : 0;
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }
}

