/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TruncateOptions
extends VersionedObjectWithAttributes {
    public static final String ATTR_KEEP_SPLITS = "TRUNCATE_KEEP_SPLITS";
    public static final boolean DEFAULT_KEEP_SPLITS = true;
    private boolean keepSplits = true;
    public static final String ATTR_TRUNCATE_ENTITY_OPTIONS = "TRUNCATE_ENTITY_OPTIONS";
    public static final TruncateEntityOptions DEFAULT_TRUNCATE_ENTITY_OPTION = TruncateEntityOptions.TRUNCATE_ACTIVE_ONLY;
    private TruncateEntityOptions truncateEntityOption = DEFAULT_TRUNCATE_ENTITY_OPTION;

    public boolean isKeepSplits() {
        return this.keepSplits;
    }

    public void setKeepSplits(boolean keepSplits) {
        this.keepSplits = keepSplits;
    }

    public TruncateEntityOptions getTruncateEntityOption() {
        return this.truncateEntityOption;
    }

    public void setTruncateEntityOption(TruncateEntityOptions truncateEntityOption) {
        this.truncateEntityOption = truncateEntityOption;
    }

    private void setupAttributes() {
        this.setAttribute(ATTR_KEEP_SPLITS, Boolean.toString(this.keepSplits));
        this.setAttribute(ATTR_TRUNCATE_ENTITY_OPTIONS, this.truncateEntityOption.name());
    }

    private void initFromAttributes() {
        String keepSplitsStr = this.getAttribute(ATTR_KEEP_SPLITS, Boolean.toString(true));
        this.keepSplits = Boolean.parseBoolean(keepSplitsStr);
        String truncateEntityOptionsStr = this.getAttribute(ATTR_TRUNCATE_ENTITY_OPTIONS, DEFAULT_TRUNCATE_ENTITY_OPTION.name());
        this.truncateEntityOption = TruncateEntityOptions.valueOf(truncateEntityOptionsStr);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.setupAttributes();
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.initFromAttributes();
    }

    public static enum TruncateEntityOptions {
        TRUNCATE_ACTIVE_ONLY,
        KEEP_TRUNCATE_ACTIVE_ONLY,
        TRUNCATE_ALL;

    }
}

