/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema.searchindex;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchHashPartition
extends VersionedObjectWithAttributes {
    private String key;
    private int bucket = -1;

    public SearchHashPartition() {
    }

    public SearchHashPartition(String key) {
        this.key = key;
    }

    public SearchHashPartition(String key, int bucket) {
        this.key = key;
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public int getBucket() {
        return this.bucket;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.key);
        WritableUtils.writeVInt(out, this.bucket);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.key = WritableUtils.readString(in);
        this.bucket = WritableUtils.readVInt(in);
    }

    public static byte[] hashPartitionsToBytes(List<SearchHashPartition> partitions) throws IOException {
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(byteArrayOutput);
        WritableUtils.writeVInt(dataOutput, partitions.size());
        for (SearchHashPartition partition : partitions) {
            partition.writeTo(dataOutput);
        }
        return byteArrayOutput.toByteArray();
    }

    public static List<SearchHashPartition> bytesToHashPartitions(byte[] data) throws IOException {
        ByteArrayInputStream byteArrayOutput = new ByteArrayInputStream(data);
        DataInputStream dataInput = new DataInputStream(byteArrayOutput);
        int count = WritableUtils.readVInt(dataInput);
        ArrayList<SearchHashPartition> partitions = CollectionUtils.newArrayListWithCapacity(count);
        for (int i = 0; i < count; ++i) {
            SearchHashPartition c = new SearchHashPartition();
            c.readFrom(dataInput);
            partitions.add(c);
        }
        return partitions;
    }

    @Override
    public String toString() {
        String str = " hash(" + this.key;
        if (this.bucket != -1) {
            return str + "(bucket=" + this.bucket + "))";
        }
        return str + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SearchHashPartition)) {
            return false;
        }
        SearchHashPartition partition = (SearchHashPartition)obj;
        if (this.key == null) {
            return partition.getKey() == null;
        }
        return this.key.equals(partition.getKey()) && this.bucket == partition.bucket;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + this.bucket;
        return result;
    }
}

