/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema.searchindex;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SearchRangeTimePartition
extends VersionedObjectWithAttributes {
    private String key;
    private String start;
    private String interval;
    private String ttl;
    private String maxOverlapMs;
    private String timeUnit;

    public SearchRangeTimePartition() {
    }

    public SearchRangeTimePartition(String key, String start, String interval) {
        this.key = key;
        this.start = start;
        this.interval = interval;
    }

    public String getKey() {
        return this.key;
    }

    public String getStart() {
        return this.start;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public String getMaxOverlapMs() {
        return this.maxOverlapMs;
    }

    public void setMaxOverlapMs(String maxOverlapMs) {
        this.maxOverlapMs = maxOverlapMs;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.key);
        WritableUtils.writeString(out, this.start);
        WritableUtils.writeString(out, this.interval);
        WritableUtils.writeString(out, this.ttl == null ? "" : this.ttl);
        WritableUtils.writeString(out, this.maxOverlapMs == null ? "" : this.maxOverlapMs);
        WritableUtils.writeString(out, this.timeUnit == null ? "" : this.timeUnit);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.key = WritableUtils.readString(in);
        this.start = WritableUtils.readString(in);
        this.interval = WritableUtils.readString(in);
        this.ttl = WritableUtils.readString(in);
        this.maxOverlapMs = WritableUtils.readString(in);
        this.timeUnit = WritableUtils.readString(in);
    }

    @Override
    public String toString() {
        String str = " range time(" + this.key + ") " + "with (start= " + this.start + ", interval=" + this.interval;
        if (this.ttl != null) {
            str = str + ", ttl=" + this.ttl;
        }
        if (this.maxOverlapMs != null) {
            str = str + ", maxOverlapMs=" + this.maxOverlapMs;
        }
        if (this.timeUnit != null) {
            str = str + ", timeUnit=" + this.timeUnit;
        }
        return str + ")";
    }

    public static SearchRangeTimePartition bytesToRangeTimePartition(byte[] bytes) throws IOException {
        SearchRangeTimePartition partition = new SearchRangeTimePartition();
        WritableUtils.getWritable(bytes, partition);
        return partition;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SearchRangeTimePartition)) {
            return false;
        }
        SearchRangeTimePartition partition = (SearchRangeTimePartition)obj;
        return this.equals(this.key, partition.getKey()) && this.equals(this.start, partition.getStart()) && this.equals(this.interval, partition.getInterval()) && this.equals(this.ttl, partition.getTtl()) && this.equals(this.maxOverlapMs, partition.getMaxOverlapMs()) && this.equals(this.timeUnit, partition.getTimeUnit());
    }

    private boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
        result = 31 * result + (this.maxOverlapMs != null ? this.maxOverlapMs.hashCode() : 0);
        result = 31 * result + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
        return result;
    }
}

