/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.tracer;

import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.utils.EagleeyeUtil;
import com.alibaba.lindorm.client.exception.OperationTimeoutException;
import com.alibaba.lindorm.client.tracer.Tracer;

public class EagleEyeTracer
implements Tracer {
    @Override
    public void startOperation(String tableName, OperationContext.OperationType operationType) {
        EagleeyeUtil.startTrace(tableName, operationType);
    }

    @Override
    public void endOperationSuccessfully(String tableName, RetryingCaller caller) {
        EagleeyeUtil.endTrace(caller.getRemoteIP(), "00");
    }

    @Override
    public void endOperationExceptionally(String tableName, RetryingCaller caller, Throwable t) {
        if (t instanceof OperationTimeoutException) {
            EagleeyeUtil.endTrace(caller.getRemoteIP(), "03");
        } else {
            EagleeyeUtil.endTrace(caller.getRemoteIP(), "01");
        }
    }

    @Override
    public Object startOperationAsync(String tableName, OperationContext.OperationType operationType) {
        return EagleeyeUtil.startTraceAsync(tableName, operationType);
    }

    @Override
    public void endOperationAsyncSuccessfully(Object eagleeyeContext, String tableName, RetryingCaller caller) {
        if (eagleeyeContext != null) {
            EagleeyeUtil.endTraceAsync(caller.getRemoteIP(), "00", eagleeyeContext);
        }
    }

    @Override
    public void endOperationAsyncExceptionally(Object eagleeyeContext, String tableName, RetryingCaller caller, Throwable t) {
        if (eagleeyeContext != null) {
            if (t instanceof OperationTimeoutException) {
                EagleeyeUtil.endTrace(caller.getRemoteIP(), "03");
            } else {
                EagleeyeUtil.endTrace(caller.getRemoteIP(), "01");
            }
        }
    }
}

