/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AliHBaseMultiClusterConnection;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Mutation;

public class AliHBaseMultiBufferedMutator
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiBufferedMutator.class);
    private volatile BufferedMutator currentBufferedMutator = null;
    private long switchCount = 0L;
    private AliHBaseMultiClusterConnection connection;
    private BufferedMutatorParams params;
    private AliHBaseConstants.ClusterType currentType;

    public AliHBaseMultiBufferedMutator(AliHBaseMultiClusterConnection connection, BufferedMutator bufferedMutator, BufferedMutatorParams params) {
        this.currentBufferedMutator = bufferedMutator;
        this.connection = connection;
        this.params = params;
        this.currentType = AliHBaseConstants.ClusterType.valueOf(connection.getConfiguration().get("hbase.cluster.type"));
        this.switchCount = connection.getSwitchCount();
    }

    private BufferedMutator getCurrentBufferedMutator() throws IOException {
        if (this.switchCount < this.connection.getSwitchCount()) {
            AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get("hbase.cluster.type"));
            if (this.currentType != AliHBaseConstants.ClusterType.HBASE || clusterType != AliHBaseConstants.ClusterType.HBASE) {
                BufferedMutator newBufferedMutator = this.connection.getBufferedMutatorByType(this.params);
                BufferedMutator lastBufferedMutator = this.currentBufferedMutator;
                this.currentBufferedMutator = newBufferedMutator;
                if (lastBufferedMutator != null) {
                    try {
                        lastBufferedMutator.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("last buffered mutator close failed" + e));
                    }
                }
            }
            this.currentType = clusterType;
            this.switchCount = this.connection.getSwitchCount();
        }
        return this.currentBufferedMutator;
    }

    public TableName getName() {
        return this.params.getTableName();
    }

    public Configuration getConfiguration() {
        return this.currentBufferedMutator.getConfiguration();
    }

    public void mutate(Mutation mutation) throws IOException {
        this.getCurrentBufferedMutator().mutate(mutation);
    }

    public void mutate(List<? extends Mutation> list) throws IOException {
        this.getCurrentBufferedMutator().mutate(list);
    }

    public void close() throws IOException {
        this.getCurrentBufferedMutator().close();
    }

    public void flush() throws IOException {
        this.getCurrentBufferedMutator().flush();
    }

    public long getWriteBufferSize() {
        return this.params.getWriteBufferSize();
    }

    public void setRpcTimeout(int timeout) {
        try {
            this.getCurrentBufferedMutator().setRpcTimeout(timeout);
        }
        catch (IOException e) {
            LOG.warn((Object)("set rpc timeout failed : " + e));
        }
    }

    public void setOperationTimeout(int timeout) {
        try {
            this.getCurrentBufferedMutator().setOperationTimeout(timeout);
        }
        catch (IOException e) {
            LOG.warn((Object)("set operation timeout failed : " + e));
        }
    }
}

