/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AliHBaseMultiClusterConnection;
import org.apache.hadoop.hbase.client.AliHBaseResultScanner;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;

public class AliHBaseMultiTable
extends HTable
implements Table {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiTable.class);
    private volatile HTable activeHTable = null;
    private volatile HTable standbyHTable = null;
    private long switchCount = 0L;
    private AliHBaseMultiClusterConnection connection;
    private Configuration conf;
    private TableName tableName;
    private AliHBaseConstants.ClusterType currentType;
    private boolean tableDualEnabled = false;
    private int glitchTimeout;
    private int scannerTimeout;

    public AliHBaseMultiTable(TableName tableName, AliHBaseMultiClusterConnection connection, HTable table) {
        super((ClusterConnection)connection, (TableBuilderBase)new HTableBuilder(tableName), null, null, (ExecutorService)new NoopExecutorService());
        this.activeHTable = table;
        this.connection = connection;
        this.tableName = tableName;
        this.currentType = AliHBaseConstants.ClusterType.valueOf(connection.getConfiguration().get("hbase.cluster.type"));
        this.switchCount = connection.getSwitchCount();
        this.conf = connection.getConfiguration();
        this.scannerTimeout = this.conf.getInt("hbase.client.scanner.timeout.period", 60000);
        if (this.conf.getBoolean("hbase.dualservice.enable", false)) {
            this.tableDualEnabled = this.conf.getBoolean("hbase.dualservice.table.enable", false) ? true : this.conf.getBoolean(DualExecutor.createTableConfKey(tableName.getNameAsString(), "hbase.dualservice.enable"), false);
            this.glitchTimeout = this.conf.getInt(DualExecutor.createTableConfKey(tableName.getNameAsString(), "hbase.dualservice.glitchtimeout"), this.conf.getInt("hbase.dualservice.glitchtimeout", 30));
            if (this.tableDualEnabled) {
                this.standbyHTable = this.connection.getHTableWithStandbyConnection(tableName);
            }
        }
    }

    private HTable getCurrentHTable() {
        if (this.switchCount < this.connection.getSwitchCount()) {
            Configuration currentConf = this.connection.getConfiguration();
            AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(currentConf.get("hbase.cluster.type"));
            if (this.currentType != AliHBaseConstants.ClusterType.HBASE || clusterType != AliHBaseConstants.ClusterType.HBASE) {
                LOG.debug((Object)("Update HTable, from " + (Object)((Object)this.currentType) + ", to " + (Object)((Object)clusterType)));
                HTable newTable = this.connection.getHTable(this.tableName);
                HTable lastHTable = this.activeHTable;
                this.activeHTable = newTable;
                if (lastHTable != null) {
                    try {
                        lastHTable.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("last htable close failed" + e));
                    }
                }
            }
            this.currentType = clusterType;
            this.switchCount = this.connection.getSwitchCount();
            this.conf = currentConf;
            if (this.tableDualEnabled) {
                this.standbyHTable = this.connection.getHTableWithStandbyConnection(this.tableName);
            }
        }
        return this.activeHTable;
    }

    public boolean getTableDualEnable() {
        return this.tableDualEnabled;
    }

    public Configuration getConfiguration() {
        return this.getCurrentHTable().getConfiguration();
    }

    public TableName getName() {
        return this.getCurrentHTable().getName();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.getCurrentHTable().getTableDescriptor();
    }

    public TableDescriptor getDescriptor() throws IOException {
        return this.getCurrentHTable().getDescriptor();
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null && scan.getLimit() > 0 && scan.getLimit() < 500) {
            return new AliHBaseResultScanner(activeTable, this.standbyHTable, executor, scan, this.glitchTimeout, this.scannerTimeout);
        }
        return activeTable.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public Result get(Get get2) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null) {
            return executor.dualGet(activeTable, this.standbyHTable, this.tableName.getName(), get2, this.glitchTimeout, this.getOperationTimeout());
        }
        return activeTable.get(get2);
    }

    public Result[] get(List<Get> gets) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null) {
            return executor.dualBatchGet(activeTable, this.standbyHTable, this.tableName.getName(), gets, this.glitchTimeout, this.getOperationTimeout());
        }
        return activeTable.get(gets);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        this.getCurrentHTable().batch(actions, results);
    }

    public void batch(List<? extends Row> actions, Object[] results, int rpcTimeout) throws InterruptedException, IOException {
        this.getCurrentHTable().batch(actions, results, rpcTimeout);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.getCurrentHTable().batchCallback(actions, results, callback);
    }

    public void delete(Delete delete) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null) {
            executor.dualDelete(activeTable, this.standbyHTable, this.tableName.getName(), delete, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        activeTable.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null) {
            executor.dualBatchDelete(activeTable, this.standbyHTable, this.tableName.getName(), deletes, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        activeTable.delete(deletes);
    }

    public void put(Put put2) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null) {
            executor.dualPut(activeTable, this.standbyHTable, this.tableName.getName(), put2, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        activeTable.put(put2);
    }

    public void put(List<Put> puts) throws IOException {
        DualExecutor executor;
        HTable activeTable = this.getCurrentHTable();
        if (this.tableDualEnabled && this.standbyHTable != null && (executor = this.connection.getDualExecutor()) != null) {
            executor.dualBatchPut(activeTable, this.standbyHTable, this.tableName.getName(), puts, this.glitchTimeout, this.getOperationTimeout());
            return;
        }
        activeTable.put(puts);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.getCurrentHTable().mutateRow(rm);
    }

    public Result append(Append append2) throws IOException {
        return this.getCurrentHTable().append(append2);
    }

    public Result increment(Increment increment2) throws IOException {
        return this.getCurrentHTable().increment(increment2);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.getCurrentHTable().incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.getCurrentHTable().incrementColumnValue(row, family, qualifier, amount, durability);
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        return this.getCurrentHTable().checkAndPut(row, family, qualifier, value, put2);
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        return this.getCurrentHTable().checkAndPut(row, family, qualifier, compareOp, value, put2);
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put2) throws IOException {
        return this.getCurrentHTable().checkAndPut(row, family, qualifier, op, value, put2);
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.getCurrentHTable().checkAndDelete(row, family, qualifier, value, delete);
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        return this.getCurrentHTable().checkAndDelete(row, family, qualifier, compareOp, value, delete);
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        return this.getCurrentHTable().checkAndDelete(row, family, qualifier, op, value, delete);
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return this.getCurrentHTable().checkAndMutate(row, family);
    }

    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        return this.getCurrentHTable().checkAndMutate(row, family, qualifier, compareOp, value, rm);
    }

    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations rm) throws IOException {
        return this.getCurrentHTable().checkAndMutate(row, family, qualifier, op, value, rm);
    }

    public boolean exists(Get get2) throws IOException {
        return this.getCurrentHTable().exists(get2);
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        return this.getCurrentHTable().exists(gets);
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.getCurrentHTable().processBatchCallback(list, results, callback);
    }

    public void close() throws IOException {
        super.close();
        if (this.activeHTable != null) {
            this.activeHTable.close();
        }
        if (this.standbyHTable != null) {
            this.standbyHTable.close();
        }
    }

    public void validatePut(Put put2) throws IllegalArgumentException {
        this.getCurrentHTable().validatePut(put2);
    }

    public void clearRegionCache() {
        this.getCurrentHTable().clearRegionCache();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.getCurrentHTable().coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.getCurrentHTable().coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.getCurrentHTable().coprocessorService(service, startKey, endKey, callable, callback);
    }

    public long getRpcTimeout(TimeUnit unit) {
        return this.getCurrentHTable().getRpcTimeout(unit);
    }

    @Deprecated
    public int getRpcTimeout() {
        return this.getCurrentHTable().getRpcTimeout();
    }

    @Deprecated
    public void setRpcTimeout(int rpcTimeout) {
        this.getCurrentHTable().setRpcTimeout(rpcTimeout);
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        return this.getCurrentHTable().getReadRpcTimeout(unit);
    }

    @Deprecated
    public int getReadRpcTimeout() {
        return this.getCurrentHTable().getReadRpcTimeout();
    }

    @Deprecated
    public void setReadRpcTimeout(int readRpcTimeout) {
        this.getCurrentHTable().setReadRpcTimeout(readRpcTimeout);
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        return this.getCurrentHTable().getWriteRpcTimeout(unit);
    }

    @Deprecated
    public int getWriteRpcTimeout() {
        return this.getCurrentHTable().getWriteRpcTimeout();
    }

    @Deprecated
    public void setWriteRpcTimeout(int writeRpcTimeout) {
        this.getCurrentHTable().setWriteRpcTimeout(writeRpcTimeout);
    }

    public long getOperationTimeout(TimeUnit unit) {
        return this.getCurrentHTable().getOperationTimeout(unit);
    }

    @Deprecated
    public int getOperationTimeout() {
        return this.getCurrentHTable().getOperationTimeout();
    }

    @Deprecated
    public void setOperationTimeout(int operationTimeout) {
        this.getCurrentHTable().setOperationTimeout(operationTimeout);
    }

    public String toString() {
        return this.getCurrentHTable().toString();
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return this.getCurrentHTable().batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.getCurrentHTable().batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    public RegionLocator getRegionLocator() {
        return this.getCurrentHTable().getRegionLocator();
    }

    private static class NoopExecutorService
    implements ExecutorService {
        private NoopExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    }

    private static class HTableBuilder
    extends TableBuilderBase {
        public HTableBuilder(TableName tableName) {
            super(tableName, new ConnectionConfiguration());
        }

        public Table build() {
            return null;
        }
    }
}

