/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.search.client.searchj.partition;

import com.alibaba.lindorm.search.client.searchj.partition.HashPartition;
import com.alibaba.lindorm.search.client.searchj.partition.Partition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;

public class CompositeHashPartition
extends Partition {
    private List<HashPartition> hashPartitions = new ArrayList<HashPartition>(3);

    public synchronized void appendHashPartition(HashPartition key) {
        if (this.hashPartitions.size() > 3) {
            throw new IllegalArgumentException("More than three partition keys are not allowed.");
        }
        this.hashPartitions.add(key);
    }

    public List<HashPartition> getHashPartitionKeys() {
        return Collections.unmodifiableList(this.hashPartitions);
    }

    @Override
    public String getRouterName() {
        return "compositeHashPartition";
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.hashPartitions);
    }

    @Override
    public void read(String json) {
        List result = (List)Utils.fromJSONString(json);
        this.hashPartitions = new ArrayList<HashPartition>(result.size());
        for (Object o : result) {
            HashPartition key = new HashPartition();
            key.init((Map)o);
            this.hashPartitions.add(key);
        }
    }
}

