/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.search.client.searchj.partition;

import com.alibaba.lindorm.search.client.searchj.partition.Partition;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;

public class HashPartition
extends Partition {
    private static final String PARTITION_BITS = "bits";
    private static final String PARTITION_KEY = "key";
    private Map<String, Object> jsonMap = new LinkedHashMap<String, Object>(3);
    private int bits = -1;
    private String key;
    private int mask = -1;

    public HashPartition() {
    }

    public HashPartition(String partitionKey) {
        this.key = partitionKey;
    }

    public HashPartition(String partitionKey, int partitionBits) {
        this.key = partitionKey;
        this.bits = partitionBits;
    }

    @Override
    public String getRouterName() {
        return "hashPartition";
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        this.jsonMap.put(PARTITION_KEY, this.key);
        if (-1 != this.bits) {
            this.jsonMap.put(PARTITION_BITS, this.bits);
        }
        jsonWriter.write(this.jsonMap);
    }

    @Override
    public void read(String json) {
        this.jsonMap = (Map)Utils.fromJSONString(json);
        this.key = (String)this.jsonMap.get(PARTITION_KEY);
        if (this.jsonMap.containsKey(PARTITION_BITS)) {
            this.bits = Integer.parseInt(this.jsonMap.get(PARTITION_BITS).toString());
        }
    }

    public void init(Map<String, Object> params) {
        this.key = (String)params.get(PARTITION_KEY);
        if (params.containsKey(PARTITION_BITS)) {
            this.bits = Integer.parseInt(params.get(PARTITION_BITS).toString());
        }
    }

    public int getBits() {
        return this.bits;
    }

    public String getKey() {
        return this.key;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }
}

