/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.search.common.cloud;

import com.alibaba.lindorm.search.client.searchj.partition.CompositeHashPartition;
import com.alibaba.lindorm.search.client.searchj.partition.HashPartition;
import com.alibaba.lindorm.search.client.searchj.partition.Partition;
import com.alibaba.lindorm.search.common.cloud.HashPartitionRouter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;

public class CompositeHashPartitionRouter
extends HashPartitionRouter {
    public static final String NAME = "compositeHashPartition";
    public static final String FIELD_SEPARATOR = "@@";
    private CompositeHashPartition partition;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(DocCollection coll) {
        Map m = (Map)coll.get("router");
        String p = (String)m.get("partitions");
        this.partition = new CompositeHashPartition();
        this.partition.read(p);
        this.setBitMask();
    }

    @Override
    public int sliceHash(String id, SolrInputDocument doc, SolrParams params, DocCollection collection) {
        if (doc == null) {
            return Hash.murmurhash3_x86_32(id, 0, id.length(), 0);
        }
        return new PartitionParser(doc, this.partition).getHash();
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String key, SolrParams params, DocCollection collection) {
        if (key == null || this.partition.getHashPartitionKeys() == null || this.partition.getHashPartitionKeys().size() == 0) {
            return collection.getActiveSlices();
        }
        if (key.indexOf("!") > 0) {
            super.getSearchSlicesSingle(key, params, collection);
        }
        DocRouter.Range completeRange = new PartitionParser(key, this.partition).getRange();
        ArrayList<Slice> targetSlices = new ArrayList<Slice>(1);
        for (Slice slice : collection.getActiveSlicesArr()) {
            DocRouter.Range range = slice.getRange();
            if (range == null || !range.overlaps(completeRange)) continue;
            targetSlices.add(slice);
        }
        return targetSlices;
    }

    @Override
    public DocRouter.Range keyHashRange(String key) {
        if (key.indexOf("!") > 0) {
            super.keyHashRange(key);
        }
        return new PartitionParser(key, this.partition).getRange();
    }

    @Override
    public DocRouter.Range getSearchRangeSingle(String key, SolrParams params, DocCollection collection) {
        if (key == null) {
            return this.fullRange();
        }
        if (key.indexOf("!") > 0) {
            super.getSearchRangeSingle(key, params, collection);
        }
        return new PartitionParser(key, this.partition).getRange();
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    private void setBitMask() {
        int[] masks;
        List<HashPartition> hashPartitions = this.partition.getHashPartitionKeys();
        if (hashPartitions.size() == 0) {
            return;
        }
        int firstBits = hashPartitions.get(0).getBits();
        if (hashPartitions.size() == 1) {
            masks = new int[]{-1};
        } else if (hashPartitions.size() == 2) {
            if (firstBits < 1 || firstBits > 32) {
                throw new IllegalArgumentException("first partition bit must be set bigger than 0 and less than 33");
            }
            masks = CompositeHashPartitionRouter.getBitMasks(firstBits);
        } else {
            int secondBits = hashPartitions.get(1).getBits();
            if (firstBits < 1 || secondBits < 1 || firstBits + secondBits > 32) {
                throw new IllegalArgumentException("first and second partition bit must be set bigger than 0, and sum of them must less than 33");
            }
            masks = CompositeHashPartitionRouter.getBitMasks(firstBits, secondBits);
        }
        for (int i = 0; i < hashPartitions.size(); ++i) {
            hashPartitions.get(i).setMask(masks[i]);
        }
    }

    public static int[] getBitMasks(int firstBits, int secondBits) {
        int[] masks = new int[3];
        masks[0] = firstBits == 0 ? 0 : -1 << 32 - firstBits;
        masks[1] = firstBits + secondBits == 0 ? 0 : -1 << 32 - firstBits - secondBits;
        masks[1] = masks[0] ^ masks[1];
        masks[2] = firstBits + secondBits == 32 ? 0 : ~(masks[0] | masks[1]);
        return masks;
    }

    public static int[] getBitMasks(int firstBits) {
        int[] masks = new int[]{firstBits == 0 ? 0 : -1 << 32 - firstBits, firstBits == 32 ? 0 : -1 >>> firstBits};
        return masks;
    }

    static class PartitionParser {
        int[] hashes;
        int[] masks;
        int fieldPieces;
        int valuePieces;

        public PartitionParser(SolrInputDocument doc, CompositeHashPartition partition) {
            this.fieldPieces = partition.getHashPartitionKeys().size();
            this.hashes = new int[this.fieldPieces];
            this.masks = new int[this.fieldPieces];
            for (int i = 0; i < this.fieldPieces; ++i) {
                String key = partition.getHashPartitionKeys().get(i).getKey();
                Object obj = doc.getFieldValue(key);
                if (obj == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No value for " + key + ", Unable to identify shard for doc:" + doc);
                }
                String fieldValue = obj.toString();
                this.hashes[i] = Hash.murmurhash3_x86_32(fieldValue, 0, fieldValue.length(), 0);
                this.masks[i] = partition.getHashPartitionKeys().get(i).getMask();
            }
        }

        public PartitionParser(String routeValue, CompositeHashPartition partition) {
            String[] values = routeValue.split(CompositeHashPartitionRouter.FIELD_SEPARATOR);
            this.fieldPieces = partition.getHashPartitionKeys().size();
            this.valuePieces = values.length;
            this.hashes = new int[this.valuePieces];
            this.masks = new int[this.fieldPieces];
            for (int i = 0; i < this.fieldPieces; ++i) {
                if (i < this.valuePieces) {
                    this.hashes[i] = Hash.murmurhash3_x86_32(values[i], 0, values[i].length(), 0);
                }
                this.masks[i] = partition.getHashPartitionKeys().get(i).getMask();
            }
        }

        DocRouter.Range getRange() {
            int upperBound;
            int lowerBound;
            switch (this.fieldPieces) {
                case 1: {
                    upperBound = lowerBound = this.hashes[0] & this.masks[0];
                    break;
                }
                case 2: {
                    if (this.valuePieces == 1) {
                        lowerBound = this.hashes[0] & this.masks[0];
                        upperBound = lowerBound | this.masks[1];
                        break;
                    }
                    upperBound = lowerBound = this.hashes[0] & this.masks[0] | this.hashes[1] & this.masks[1];
                    break;
                }
                case 3: {
                    if (this.valuePieces == 1) {
                        lowerBound = this.hashes[0] & this.masks[0];
                        upperBound = lowerBound | ~this.masks[0];
                        break;
                    }
                    if (this.valuePieces == 2) {
                        lowerBound = this.hashes[0] & this.masks[0] | this.hashes[1] & this.masks[1];
                        upperBound = lowerBound | ~(this.masks[0] | this.masks[1]);
                        break;
                    }
                    upperBound = lowerBound = this.hashes[0] & this.masks[0] | this.hashes[1] & this.masks[1] | this.hashes[2] & this.masks[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("router field syntax error, tri level at most");
                }
            }
            if (this.masks[0] == 0 && this.fieldPieces != 3 || this.masks[0] == 0 && this.masks[1] == 0) {
                lowerBound = Integer.MIN_VALUE;
                upperBound = Integer.MAX_VALUE;
            }
            return new DocRouter.Range(lowerBound, upperBound);
        }

        int getHash() {
            int result = this.hashes[0] & this.masks[0];
            for (int i = 1; i < this.fieldPieces; ++i) {
                result |= this.hashes[i] & this.masks[i];
            }
            return result;
        }
    }
}

