/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.search.common.cloud;

import com.alibaba.lindorm.search.client.searchj.partition.HashPartition;
import com.alibaba.lindorm.search.client.searchj.partition.Partition;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;

public class HashPartitionRouter
extends CompositeIdRouter {
    public static final String NAME = "hashPartition";
    private HashPartition partition;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(DocCollection coll) {
        Map m = (Map)coll.get("router");
        String p = (String)m.get("partitions");
        this.partition = new HashPartition();
        this.partition.read(p);
    }

    @Override
    public int sliceHash(String id, SolrInputDocument doc, SolrParams params, DocCollection collection) {
        String fieldName = this.partition.getKey();
        if (null != doc) {
            Object o = doc.getFieldValue(fieldName);
            if (o == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No value for " + fieldName + ". Unable to identify shard for doc:" + doc);
            }
            id = o.toString();
        }
        return this.calcHash(id);
    }

    @Override
    public DocRouter.Range keyHashRange(String key) {
        if (key.indexOf("!") > 0) {
            super.keyHashRange(key);
        }
        int hash = this.calcHash(key);
        return new DocRouter.Range(hash, hash);
    }

    @Override
    public DocRouter.Range getSearchRangeSingle(String key, SolrParams params, DocCollection collection) {
        if (key == null) {
            return this.fullRange();
        }
        if (key.indexOf("!") > 0) {
            super.getSearchRangeSingle(key, params, collection);
        }
        int hash = this.calcHash(key);
        return new DocRouter.Range(hash, hash);
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String key, SolrParams params, DocCollection collection) {
        if (key == null) {
            return collection.getActiveSlices();
        }
        if (key.indexOf("!") > 0) {
            super.getSearchSlicesSingle(key, params, collection);
        }
        int hash = this.calcHash(key);
        return Collections.singletonList(this.hashToSlice(hash, collection));
    }

    public Partition getPartition() {
        return this.partition;
    }
}

