/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.search.common.cloud;

import com.alibaba.lindorm.search.common.cloud.RouterFieldTimeUnit;
import com.alibaba.lindorm.search.common.util.TimeRoutedCollectionSuffix;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;

public class TimeRoutedAliasClient {
    public static final RoutedAliasTypes TYPE = RoutedAliasTypes.TIME;
    public static final String ROUTER_PREFIX = "router.";
    public static final String ROUTER_TYPE_NAME = "router.name";
    public static final String ROUTER_FIELD = "router.field";
    public static final String ROUTER_COLLECTION_SUFFIX = "router.collectionSuffix";
    public static final String ROUTER_FIELD_TIME_UNIT = "router.fieldTimeUnit";
    public static final long MIN_SECOND = -31557014167219200L;
    public static final long MAX_SECOND = 31556889864403199L;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("[_HH[_mm[_ss]]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC);
    private final String aliasName;
    private final String routeField;
    private final TimeRoutedCollectionSuffix cs;
    private final String fieldTimeUnit;

    public TimeRoutedAliasClient(String aliasName, Map<String, String> aliasMetadata) {
        this.aliasName = aliasName;
        MapSolrParams params = new MapSolrParams(aliasMetadata);
        RequiredSolrParams required = params.required();
        if (!"time".equals(required.get(ROUTER_TYPE_NAME))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only 'time' routed aliases is supported right now.");
        }
        this.routeField = required.get(ROUTER_FIELD);
        this.cs = TimeRoutedCollectionSuffix.valueOf(params.get(ROUTER_COLLECTION_SUFFIX, TimeRoutedCollectionSuffix.DATE.name()));
        this.fieldTimeUnit = params.get(ROUTER_FIELD_TIME_UNIT, "ms");
    }

    public List<Map.Entry<Instant, String>> parseCollections(Aliases aliases, Supplier<SolrException> aliasNotExist) {
        List<String> collections = aliases.getCollectionAliasListMap().get(this.aliasName);
        if (collections == null) {
            throw aliasNotExist.get();
        }
        ArrayList<Map.Entry<Instant, String>> result = new ArrayList<Map.Entry<Instant, String>>(collections.size());
        for (String collection : collections) {
            Instant colStartTime = TimeRoutedAliasClient.parseInstantFromCollectionName(this.aliasName, collection, this.cs);
            result.add(new AbstractMap.SimpleImmutableEntry<Instant, String>(colStartTime, collection));
        }
        result.sort((e1, e2) -> ((Instant)e2.getKey()).compareTo((Instant)e1.getKey()));
        return result;
    }

    public Instant longToInstant(long time) {
        if (this.fieldTimeUnit.equals(RouterFieldTimeUnit.SECOND.getUnit())) {
            return Instant.ofEpochSecond(time);
        }
        return Instant.ofEpochMilli(time);
    }

    public Instant parseRouteKey(Object routeKey) {
        Instant docTimestamp = routeKey instanceof Instant ? (Instant)routeKey : (routeKey instanceof Date ? ((Date)routeKey).toInstant() : (routeKey instanceof CharSequence ? Instant.parse((CharSequence)routeKey) : (routeKey instanceof Long ? this.longToInstant((Long)routeKey) : null)));
        return docTimestamp;
    }

    public static boolean isRoutedAlias(String aliasName, Aliases aliases) {
        Map<String, String> aliasProperties = aliases.getCollectionAliasProperties(aliasName);
        return aliasProperties.containsKey(ROUTER_TYPE_NAME);
    }

    public static Instant parseInstantFromCollectionName(String aliasName, String collection, TimeRoutedCollectionSuffix cs) {
        String separatorPrefix = TYPE.getSeparatorPrefix();
        boolean isSeparatorPrefix = collection.contains(separatorPrefix);
        String timePart = isSeparatorPrefix ? collection.substring(collection.lastIndexOf(separatorPrefix) + separatorPrefix.length()) : collection.substring(aliasName.length() + 1);
        switch (cs) {
            case MS: {
                return Instant.ofEpochMilli(Long.parseLong(timePart));
            }
        }
        return DATE_TIME_FORMATTER.parse((CharSequence)timePart, Instant::from);
    }

    public TimeRoutedCollectionSuffix getCollectionSuffix() {
        return this.cs;
    }

    public static List<String> findCollection(Aliases aliases, String name, long start, long end) {
        ArrayList<String> collections = new ArrayList<String>();
        if (start > end) {
            return collections;
        }
        if (aliases.isRoutedAlias(name)) {
            TimeRoutedAliasClient timeRoutedAlias = new TimeRoutedAliasClient(name, aliases.getCollectionAliasProperties(name));
            List<String> aliasedCollections = aliases.getCollectionAliasListMap().get(name);
            ArrayList<AbstractMap.SimpleImmutableEntry<Instant, String>> collectionsInstant = new ArrayList<AbstractMap.SimpleImmutableEntry<Instant, String>>(aliasedCollections.size());
            for (String collectionName : aliasedCollections) {
                Instant instant = TimeRoutedAliasClient.parseInstantFromCollectionName(name, collectionName, timeRoutedAlias.getCollectionSuffix());
                collectionsInstant.add(new AbstractMap.SimpleImmutableEntry<Instant, String>(instant, collectionName));
            }
            Instant startI = timeRoutedAlias.longToInstant(start);
            Instant endI = timeRoutedAlias.longToInstant(end);
            for (Map.Entry entry : collectionsInstant) {
                Instant colStartTime = (Instant)entry.getKey();
                if (endI.isBefore(colStartTime)) continue;
                collections.add((String)entry.getValue());
                if (startI.isBefore(colStartTime)) continue;
                break;
            }
        } else {
            collections.add(name);
        }
        return collections;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getRouteField() {
        return this.routeField;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("aliasName:" + this.aliasName).append("routeField:" + this.routeField).toString();
    }
}

