/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface CollectionParams {
    public static final String ACTION = "action";
    public static final String NAME = "name";
    @Deprecated
    public static final String FROM_NODE = "fromNode";
    public static final String SOURCE_NODE = "sourceNode";
    public static final String TARGET_NODE = "targetNode";
    public static final Map<String, CollectionAction> actions = Collections.unmodifiableMap(Stream.of(CollectionAction.values()).collect(Collectors.toMap(CollectionAction::toLower, Function.identity())));

    public static enum CollectionAction {
        CREATE(true, LockLevel.COLLECTION),
        DELETE(true, LockLevel.COLLECTION),
        RELOAD(true, LockLevel.COLLECTION),
        SYNCSHARD(true, LockLevel.SHARD),
        CREATEALIAS(true, LockLevel.COLLECTION),
        DELETEALIAS(true, LockLevel.COLLECTION),
        ALIASPROP(true, LockLevel.COLLECTION),
        LISTALIASES(false, LockLevel.NONE),
        MAINTAINROUTEDALIAS(true, LockLevel.COLLECTION),
        DELETEROUTEDALIASCOLLECTIONS(true, LockLevel.COLLECTION),
        SPLITSHARD(true, LockLevel.SHARD),
        DELETESHARD(true, LockLevel.SHARD),
        CREATESHARD(true, LockLevel.COLLECTION),
        DELETEREPLICA(true, LockLevel.SHARD),
        FORCELEADER(true, LockLevel.SHARD),
        MIGRATE(true, LockLevel.COLLECTION),
        ADDROLE(true, LockLevel.NONE),
        REMOVEROLE(true, LockLevel.NONE),
        CLUSTERPROP(true, LockLevel.NONE),
        COLLECTIONPROP(true, LockLevel.COLLECTION),
        REQUESTSTATUS(false, LockLevel.NONE),
        DELETESTATUS(false, LockLevel.NONE),
        ADDREPLICA(true, LockLevel.SHARD),
        MOVEREPLICA(true, LockLevel.SHARD),
        OVERSEERSTATUS(false, LockLevel.NONE),
        LIST(false, LockLevel.NONE),
        LOGREPLAYREPLICA(true, LockLevel.NONE),
        CLUSTERSTATUS(false, LockLevel.NONE),
        ADDREPLICAPROP(true, LockLevel.REPLICA),
        DELETEREPLICAPROP(true, LockLevel.REPLICA),
        BALANCESHARDUNIQUE(true, LockLevel.SHARD),
        REBALANCELEADERS(true, LockLevel.COLLECTION),
        MODIFYCOLLECTION(true, LockLevel.COLLECTION),
        MIGRATESTATEFORMAT(true, LockLevel.CLUSTER),
        BACKUP(true, LockLevel.COLLECTION),
        RESTORE(true, LockLevel.COLLECTION),
        LISTBACKUP(false, LockLevel.NONE),
        DELETEBACKUP(true, LockLevel.COLLECTION),
        CREATESNAPSHOT(true, LockLevel.COLLECTION),
        DELETESNAPSHOT(true, LockLevel.COLLECTION),
        LISTSNAPSHOTS(false, LockLevel.NONE),
        UTILIZENODE(false, LockLevel.NONE),
        MOCK_COLL_TASK(false, LockLevel.COLLECTION),
        MOCK_SHARD_TASK(false, LockLevel.SHARD),
        REPLACENODE(true, LockLevel.NONE),
        DELETENODE(true, LockLevel.NONE),
        MOCK_REPLICA_TASK(false, LockLevel.REPLICA),
        NONE(false, LockLevel.NONE),
        MERGESHARDS(true, LockLevel.SHARD),
        COLSTATUS(true, LockLevel.NONE),
        REINDEXCOLLECTION(true, LockLevel.NONE),
        RENAME(true, LockLevel.COLLECTION),
        LISTCOLLECTIONINFO(false, LockLevel.NONE);

        public final boolean isWrite;
        public final String lowerName;
        public final LockLevel lockLevel;

        private CollectionAction(boolean isWrite, LockLevel level) {
            this.isWrite = isWrite;
            this.lockLevel = level;
            this.lowerName = this.toString().toLowerCase(Locale.ROOT);
        }

        public static CollectionAction get(String p) {
            return actions.get(p == null ? null : p.toLowerCase(Locale.ROOT));
        }

        public boolean isEqual(String s) {
            return s != null && this.lowerName.equals(s.toLowerCase(Locale.ROOT));
        }

        public String toLower() {
            return this.lowerName;
        }
    }

    public static enum LockLevel {
        CLUSTER(0),
        COLLECTION(1),
        SHARD(2),
        REPLICA(3),
        NONE(10);

        public final int level;

        private LockLevel(int i) {
            this.level = i;
        }

        public LockLevel getChild() {
            return LockLevel.getLevel(this.level + 1);
        }

        public static LockLevel getLevel(int i) {
            for (LockLevel v : LockLevel.values()) {
                if (v.level != i) continue;
                return v;
            }
            return null;
        }

        public boolean isHigherOrEqual(LockLevel that) {
            return that.level <= this.level;
        }
    }
}

