/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common.config;

import com.alibaba.metrics.MetricLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MetricsCollectPeriodConfig {
    public static final int DEFAULT_INTERVAL = 60;
    private Map<MetricLevel, Integer> levelPeriodMap = new HashMap<MetricLevel, Integer>();
    private int globalPeriod = 60;

    public MetricsCollectPeriodConfig() {
        this.fillLevelPeriodMap();
    }

    public MetricsCollectPeriodConfig(int globalPeriodSeconds) {
        this();
        this.configGlobalPeriod(globalPeriodSeconds);
    }

    private void fillLevelPeriodMap() {
        this.levelPeriodMap.put(MetricLevel.CRITICAL, 1);
        this.levelPeriodMap.put(MetricLevel.MAJOR, 5);
        this.levelPeriodMap.put(MetricLevel.NORMAL, 15);
        this.levelPeriodMap.put(MetricLevel.MINOR, 30);
        this.levelPeriodMap.put(MetricLevel.TRIVIAL, 60);
    }

    public MetricsCollectPeriodConfig configPeriod(MetricLevel level, int seconds) {
        if (seconds < 0) {
            seconds = 214748;
        }
        this.levelPeriodMap.put(level, seconds);
        return this;
    }

    public MetricsCollectPeriodConfig configGlobalPeriod(int globalPeriodSeconds) {
        if (globalPeriodSeconds < 0) {
            globalPeriodSeconds = 214748;
        }
        this.globalPeriod = globalPeriodSeconds;
        return this;
    }

    public int period(MetricLevel level) {
        Integer value = this.levelPeriodMap.get(level);
        return value != null ? value : this.globalPeriod;
    }

    public Map<MetricLevel, Integer> rawLevelPeriodMap() {
        return Collections.unmodifiableMap(this.levelPeriodMap);
    }
}

