/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common.filter;

import com.alibaba.metrics.Metric;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricName;
import java.util.ArrayList;
import java.util.Arrays;

public class CompositeMetricFilter
implements MetricFilter {
    MetricFilter[] filters;

    public CompositeMetricFilter(MetricFilter ... filters) {
        ArrayList<MetricFilter> filterList = new ArrayList<MetricFilter>(Arrays.asList(filters));
        filterList.remove(MetricFilter.ALL);
        if (!filterList.isEmpty()) {
            this.filters = filterList.toArray(new MetricFilter[filterList.size()]);
        }
    }

    public boolean matches(MetricName name, Metric metric) {
        if (this.filters != null) {
            for (MetricFilter filter : this.filters) {
                if (filter.matches(name, metric)) continue;
                return false;
            }
        }
        return true;
    }
}

