/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.appactive.channel.PathUtil;
import io.appactive.channel.file.FileConstant;
import io.appactive.channel.file.FilePathUtil;
import io.appactive.channel.file.FileReadDataSource;
import io.appactive.channel.nacos.NacosPathUtil;
import io.appactive.channel.nacos.NacosReadDataSource;
import io.appactive.java.api.base.exception.ExceptionFactory;
import io.appactive.java.api.channel.ChannelTypeEnum;
import io.appactive.java.api.channel.ConfigReadDataSource;
import io.appactive.java.api.channel.ConfigWriteDataSource;
import io.appactive.java.api.channel.ConverterInterface;
import io.appactive.java.api.utils.lang.StringUtils;
import io.appactive.support.sys.JvmPropertyUtil;
import java.util.Properties;

public class ClientChannelService {
    private static final ChannelTypeEnum CHANNEL_TYPE_ENUM;

    public static <T> ConfigReadDataSource<T> getConfigReadDataSource(String uri) {
        ConverterInterface ruleConverterInterface = source -> {
            try {
                Object bo = JSON.parseObject((String)source, (TypeReference)new TypeReference<T>(){}, (Feature[])new Feature[0]);
                return bo;
            }
            catch (Exception e) {
                throw ExceptionFactory.makeFault((String)"unsupported content:{}", (String)source);
            }
        };
        return ClientChannelService.getConfigReadDataSource(uri, ruleConverterInterface);
    }

    public static <T> ConfigReadDataSource<T> getConfigReadDataSource(String uri, ConverterInterface<String, T> ruleConverterInterface) {
        Object configReadDataSource;
        if (StringUtils.isBlank((CharSequence)uri)) {
            throw ExceptionFactory.makeFault((String)"uri is empty");
        }
        switch (CHANNEL_TYPE_ENUM) {
            case FILE: {
                configReadDataSource = new FileReadDataSource<T>(uri, FileConstant.DEFAULT_CHARSET, 0x100000, ruleConverterInterface);
                break;
            }
            case NACOS: {
                PathUtil pathUtil = ClientChannelService.getPathUtil();
                Properties extra = pathUtil.getExtras();
                configReadDataSource = new NacosReadDataSource<T>(pathUtil.getConfigServerAddress(), uri, extra.getProperty("appactive.groupId"), extra.getProperty("appactive.namespaceId"), ruleConverterInterface);
                break;
            }
            default: {
                throw ExceptionFactory.makeFault((String)"unsupported channel:{}", (String)CHANNEL_TYPE_ENUM.name());
            }
        }
        return configReadDataSource;
    }

    public static <T> ConfigWriteDataSource<T> getConfigWriteDataSource(String uri, T clazz) {
        return null;
    }

    public static PathUtil getPathUtil() {
        switch (CHANNEL_TYPE_ENUM) {
            case NACOS: {
                return NacosPathUtil.getInstance();
            }
            case FILE: {
                return FilePathUtil.getInstance();
            }
        }
        throw ExceptionFactory.makeFault((String)"unsupported channel:{}", (String)CHANNEL_TYPE_ENUM.name());
    }

    public static String getSubKeySplit() {
        switch (CHANNEL_TYPE_ENUM) {
            case NACOS: {
                return "_";
            }
            case FILE: {
                return "/";
            }
        }
        throw ExceptionFactory.makeFault((String)"unsupported channel:{}", (String)CHANNEL_TYPE_ENUM.name());
    }

    static {
        String channelType = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.channelTypeEnum");
        CHANNEL_TYPE_ENUM = StringUtils.isBlank((CharSequence)channelType) ? ChannelTypeEnum.FILE : ChannelTypeEnum.valueOf((String)channelType);
    }
}

