/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel.file;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.appactive.channel.PathUtil;
import io.appactive.channel.file.FileConstant;
import io.appactive.channel.file.FileReadDataSource;
import io.appactive.java.api.channel.ConverterInterface;
import io.appactive.java.api.utils.lang.StringUtils;
import io.appactive.support.log.LogUtil;
import io.appactive.support.sys.JvmPropertyUtil;
import java.util.Map;
import java.util.Properties;

public class FilePathUtil
implements PathUtil {
    private static final String ALL_RULE_DEFINE_PATH = "/home/admin/appactive/path-address";
    private static volatile FilePathUtil instance;
    private String machineRulePath;
    private String dataScopeRuleDirectoryPath;
    private String forbiddenRulePath;
    private String trafficRouteRulePath;
    private String transformerRulePath;
    private String idSourceRulePath;

    public FilePathUtil() {
        try {
            this.initPathValue();
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilePathUtil getInstance() {
        if (instance != null) return instance;
        Class<FilePathUtil> clazz = FilePathUtil.class;
        synchronized (FilePathUtil.class) {
            if (instance != null) return instance;
            instance = new FilePathUtil();
            LogUtil.warn((String)"instance: {}", (Object[])new Object[]{instance});
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getMachineRulePath() {
        return this.machineRulePath;
    }

    @Override
    public String getDataScopeRuleDirectoryPath() {
        return this.dataScopeRuleDirectoryPath;
    }

    @Override
    public String getForbiddenRulePath() {
        return this.forbiddenRulePath;
    }

    @Override
    public String getTrafficRouteRulePath() {
        return this.trafficRouteRulePath;
    }

    @Override
    public String getTransformerRulePath() {
        return this.transformerRulePath;
    }

    @Override
    public String getIdSourceRulePath() {
        return this.idSourceRulePath;
    }

    @Override
    public String getConfigServerAddress() {
        return ALL_RULE_DEFINE_PATH;
    }

    @Override
    public Properties getAuth() {
        return null;
    }

    @Override
    public Properties getExtras() {
        return null;
    }

    private void initPathValue() throws Exception {
        this.initFromSys();
        this.initFromFile();
    }

    private void initFromSys() {
        this.machineRulePath = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.machineRulePath");
        this.dataScopeRuleDirectoryPath = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.dataScopeRuleDirectoryPath");
        this.forbiddenRulePath = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.forbiddenRulePath");
        this.trafficRouteRulePath = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.trafficRulePath");
        this.transformerRulePath = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.transformerRulePath");
        this.idSourceRulePath = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.idSourceRulePath");
    }

    private void initFromFile() throws Exception {
        String filePathName = JvmPropertyUtil.getJvmAndEnvValue((String)"appactive.path");
        if (StringUtils.isBlank((CharSequence)filePathName)) {
            filePathName = ALL_RULE_DEFINE_PATH;
        }
        ConverterInterface converterInterface = source -> (Map)JSON.parseObject((String)source, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        FileReadDataSource fileReadDataSource = new FileReadDataSource(filePathName, FileConstant.DEFAULT_CHARSET, 0x100000, converterInterface);
        Map pathMap = (Map)fileReadDataSource.read();
        if (this.machineRulePath == null) {
            this.machineRulePath = (String)pathMap.get("appactive.machineRulePath");
        }
        if (this.dataScopeRuleDirectoryPath == null) {
            this.dataScopeRuleDirectoryPath = (String)pathMap.get("appactive.dataScopeRuleDirectoryPath");
        }
        if (this.forbiddenRulePath == null) {
            this.forbiddenRulePath = (String)pathMap.get("appactive.forbiddenRulePath");
        }
        if (this.trafficRouteRulePath == null) {
            this.trafficRouteRulePath = (String)pathMap.get("appactive.trafficRulePath");
        }
        if (this.transformerRulePath == null) {
            this.transformerRulePath = (String)pathMap.get("appactive.transformerRulePath");
        }
        if (this.idSourceRulePath == null) {
            this.idSourceRulePath = (String)pathMap.get("appactive.idSourceRulePath");
        }
    }

    public String toString() {
        return "FilePathUtil{machineRulePath='" + this.machineRulePath + '\'' + ", dataScopeRuleDirectoryPath='" + this.dataScopeRuleDirectoryPath + '\'' + ", forbiddenRulePath='" + this.forbiddenRulePath + '\'' + ", trafficRouteRulePath='" + this.trafficRouteRulePath + '\'' + ", transformerRulePath='" + this.transformerRulePath + '\'' + ", idSourceRulePath='" + this.idSourceRulePath + '\'' + '}';
    }
}

