/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel.file;

import io.appactive.java.api.channel.ConfigReadDataSource;
import io.appactive.java.api.channel.ConverterInterface;
import io.appactive.java.api.channel.listener.DataListener;
import io.appactive.support.log.LogUtil;
import io.appactive.support.thread.SafeWrappers;
import io.appactive.support.thread.ThreadPoolService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FileReadDataSource<T>
implements ConfigReadDataSource<T> {
    private final File file;
    private final Charset charset;
    private byte[] buf;
    private final ConverterInterface<String, T> converterInterface;
    private List<DataListener<T>> dataListeners = new ArrayList<DataListener<T>>();
    private long timerPeriod = 3000L;
    private T memoryValue = null;
    private long lastModified = 0L;

    public FileReadDataSource(String filePath, Charset charset, byte[] buf, ConverterInterface<String, T> converterInterface) {
        this(new File(filePath), charset, buf, converterInterface);
    }

    public FileReadDataSource(String filePath, Charset charset, int bufSize, ConverterInterface<String, T> converterInterface) {
        this(new File(filePath), charset, new byte[bufSize], converterInterface);
    }

    public FileReadDataSource(File file, Charset charset, byte[] buf, ConverterInterface<String, T> converterInterface) {
        this(file, charset, buf, null, converterInterface);
    }

    public FileReadDataSource(File file, Charset charset, byte[] buf, Long timerPeriod, ConverterInterface<String, T> converterInterface) {
        this.file = file;
        this.charset = charset;
        this.buf = buf;
        if (timerPeriod != null && timerPeriod > 0L) {
            this.timerPeriod = timerPeriod;
        }
        this.converterInterface = converterInterface;
        this.initMemoryValue();
        this.startTimerService();
    }

    private void startTimerService() {
        ScheduledExecutorService executorService = ThreadPoolService.createSingleThreadScheduledExecutor((String)"appactive.file-read-value-task");
        executorService.scheduleAtFixedRate(SafeWrappers.safeRunnable((Runnable)this.checkFileChanged()), this.timerPeriod, this.timerPeriod, TimeUnit.MILLISECONDS);
    }

    private Runnable checkFileChanged() {
        return new Runnable(){

            @Override
            public void run() {
                FileReadDataSource.this.initMemoryValue();
            }
        };
    }

    private void initMemoryValue() {
        if (!this.isModified()) {
            return;
        }
        try {
            T oldValue = this.memoryValue;
            T valueFromFile = this.getValueFromSource();
            this.listenerNotify(oldValue, valueFromFile);
            this.memoryValue = valueFromFile;
        }
        catch (IOException e) {
            LogUtil.error((String)("file-read-failed,e:" + e.getMessage()), (Throwable)e);
        }
    }

    private boolean isModified() {
        long curLastModified = this.file.lastModified();
        if (curLastModified != this.lastModified) {
            this.lastModified = curLastModified;
            return true;
        }
        return false;
    }

    public T read() throws Exception {
        return this.memoryValue;
    }

    public void addDataChangedListener(DataListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.dataListeners.add(listener);
        listener.dataChanged(null, this.memoryValue);
    }

    public List<DataListener<T>> getDataListeners() {
        return this.dataListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getValueFromSource() throws IOException {
        if (this.file == null) {
            LogUtil.warn((String)"[FileReadDataSource] File is null", (Object[])new Object[0]);
            return null;
        }
        if (!this.file.exists() || !this.file.isFile()) {
            LogUtil.warn((String)String.format("[FileReadDataSource] File not exist or is not file: %s", this.file.getAbsolutePath()), (Object[])new Object[0]);
            return null;
        }
        FileInputStream inputStream = null;
        try {
            Object convert;
            inputStream = new FileInputStream(this.file);
            FileChannel channel = inputStream.getChannel();
            if (channel.size() > (long)this.buf.length) {
                throw new IllegalStateException(this.file.getAbsolutePath() + " file size=" + channel.size() + ", is bigger than bufSize=" + this.buf.length + ". Can't read");
            }
            int len = inputStream.read(this.buf);
            if (len < 0) {
                T t = null;
                return t;
            }
            String s = new String(this.buf, 0, len, this.charset);
            Object object = convert = this.converterInterface.convert((Object)s);
            return (T)object;
        }
        catch (Exception e) {
            LogUtil.warn((String)"FileReadDataSource Exception: {}", (Throwable)e.getCause());
            T t = null;
            return t;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void close() throws Exception {
        this.buf = null;
    }
}

