/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel.file;

import io.appactive.java.api.channel.ConfigWriteDataSource;
import io.appactive.java.api.channel.ConverterInterface;
import io.appactive.support.log.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;

public class FileWriteDataSource<T>
implements ConfigWriteDataSource<T> {
    private final File file;
    private final Charset charset;
    private final ConverterInterface<T, String> converterInterface;

    public FileWriteDataSource(String filePath, Charset charset, ConverterInterface<T, String> converterInterface) {
        this(new File(filePath), charset, converterInterface);
    }

    public FileWriteDataSource(File file, Charset charset, ConverterInterface<T, String> converterInterface) {
        this.file = file;
        this.charset = charset;
        this.converterInterface = converterInterface;
    }

    public boolean write(T value) throws Exception {
        return this.syncWriteFile(value);
    }

    public boolean write(T value, String type) throws Exception {
        return this.syncWriteFile(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncWriteFile(T value) throws Exception {
        String convertResult = (String)this.converterInterface.convert(value);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.file);
            byte[] bytesArray = convertResult.getBytes(this.charset);
            LogUtil.info((String)"[FileWritableDataSource] Writing to file {}: {}", (Object[])new Object[]{this.file, convertResult});
            outputStream.write(bytesArray);
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public void close() throws Exception {
    }
}

