/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel.nacos;

import io.appactive.channel.PathUtil;
import io.appactive.java.api.utils.lang.StringUtils;
import io.appactive.support.log.LogUtil;
import io.appactive.support.sys.JvmPropertyUtil;
import java.util.Properties;

public class NacosPathUtil
implements PathUtil {
    private static volatile NacosPathUtil instance;
    private String machineRulePath;
    private String dataScopeRuleDirectoryPath;
    private String forbiddenRulePath;
    private String trafficRouteRulePath;
    private String transformerRulePath;
    private String idSourceRulePath;
    private String configServerAddress;
    private final Properties extras = new Properties();
    private final Properties auths = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NacosPathUtil getInstance() {
        if (instance != null) return instance;
        Class<NacosPathUtil> clazz = NacosPathUtil.class;
        synchronized (NacosPathUtil.class) {
            if (instance != null) return instance;
            instance = new NacosPathUtil();
            LogUtil.warn((String)"instance: {}", (Object[])new Object[]{instance});
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public NacosPathUtil() {
        try {
            this.initPathValue();
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getMachineRulePath() {
        return this.machineRulePath;
    }

    @Override
    public String getDataScopeRuleDirectoryPath() {
        return this.dataScopeRuleDirectoryPath;
    }

    @Override
    public String getForbiddenRulePath() {
        return this.forbiddenRulePath;
    }

    @Override
    public String getTrafficRouteRulePath() {
        return this.trafficRouteRulePath;
    }

    @Override
    public String getTransformerRulePath() {
        return this.transformerRulePath;
    }

    @Override
    public String getIdSourceRulePath() {
        return this.idSourceRulePath;
    }

    @Override
    public String getConfigServerAddress() {
        return this.configServerAddress;
    }

    @Override
    public Properties getAuth() {
        return this.auths;
    }

    @Override
    public Properties getExtras() {
        return this.extras;
    }

    private void initPathValue() throws Exception {
        this.initFromSys();
    }

    private void initFromSys() {
        String key = "appactive.dataId.machineRulePath";
        String value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.machineRulePath = value == null ? key : value;
        key = "appactive.dataId.dataScopeRuleDirectoryPath";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.dataScopeRuleDirectoryPath = value == null ? key : value;
        key = "appactive.dataId.forbiddenRulePath";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.forbiddenRulePath = value == null ? key : value;
        key = "appactive.dataId.trafficRouteRulePath";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.trafficRouteRulePath = value == null ? key : value;
        key = "appactive.dataId.transformerRulePath";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.transformerRulePath = value == null ? key : value;
        key = "appactive.dataId.idSourceRulePath";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.idSourceRulePath = value == null ? key : value;
        key = "appactive.configServerAddress";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        this.configServerAddress = value == null ? "127.0.0.1:8848" : value;
        key = "appactive.groupId";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        value = value == null ? key : value;
        this.extras.put(key, value);
        key = "appactive.namespaceId";
        value = JvmPropertyUtil.getJvmAndEnvValue((String)key);
        String namespaceId = "";
        if (StringUtils.isNotBlank((String)value)) {
            namespaceId = value;
        }
        this.extras.put(key, namespaceId);
    }

    public String toString() {
        return "NacosPathUtil{machineRulePath='" + this.machineRulePath + '\'' + ", dataScopeRuleDirectoryPath='" + this.dataScopeRuleDirectoryPath + '\'' + ", forbiddenRulePath='" + this.forbiddenRulePath + '\'' + ", trafficRouteRulePath='" + this.trafficRouteRulePath + '\'' + ", transformerRulePath='" + this.transformerRulePath + '\'' + ", idSourceRulePath='" + this.idSourceRulePath + '\'' + ", configServerAddress='" + this.configServerAddress + '\'' + ", extras=" + this.extras + ", auths=" + this.auths + '}';
    }
}

