/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import io.appactive.java.api.channel.ConfigReadDataSource;
import io.appactive.java.api.channel.ConverterInterface;
import io.appactive.java.api.channel.listener.DataListener;
import io.appactive.support.log.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;

public class NacosReadDataSource<T>
implements ConfigReadDataSource<T> {
    private final ConverterInterface<String, T> converterInterface;
    private List<DataListener<T>> dataListeners = new ArrayList<DataListener<T>>();
    private String serverAddr;
    private String dataId;
    private String groupId;
    private String namespaceId;
    private ConfigService configService;
    private long timerPeriod = 3000L;
    private T memoryValue = null;
    private long lastModified = 0L;
    private long curLastModified = -1L;

    public NacosReadDataSource(String serverAddr, String dataId, String groupId, ConverterInterface<String, T> converterInterface) {
        this(serverAddr, dataId, groupId, "", converterInterface);
    }

    public NacosReadDataSource(String serverAddr, String dataId, String groupId, String namespaceId, ConverterInterface<String, T> converterInterface) {
        this.serverAddr = serverAddr;
        this.dataId = dataId;
        this.groupId = groupId;
        this.namespaceId = namespaceId;
        this.converterInterface = converterInterface;
        this.startTimerService();
        this.initMemoryValue(null);
    }

    private void startTimerService() {
        try {
            Properties properties = new Properties();
            properties.put("serverAddr", this.serverAddr);
            properties.put("namespace", this.namespaceId);
            this.configService = NacosFactory.createConfigService((Properties)properties);
            this.configService.addListener(this.dataId, this.groupId, new Listener(){

                public void receiveConfigInfo(String configInfo) {
                    NacosReadDataSource.this.lastModified = System.currentTimeMillis();
                    LogUtil.warn((String)"get Nacos configInfo {}", (Object[])new Object[]{configInfo});
                    NacosReadDataSource.this.initMemoryValue(NacosReadDataSource.this.converterInterface.convert((Object)configInfo));
                }

                public Executor getExecutor() {
                    return null;
                }
            });
        }
        catch (NacosException e) {
            LogUtil.error((String)"get Nacos configService Exception ", (Throwable)e);
        }
    }

    private void initMemoryValue(T newValue) {
        if (!this.isModified()) {
            return;
        }
        try {
            T oldValue = this.memoryValue;
            if (newValue == null) {
                newValue = this.getValueFromSource();
            }
            this.listenerNotify(oldValue, newValue);
            this.memoryValue = newValue;
        }
        catch (IOException e) {
            LogUtil.error((String)("nacos-read-failed,e:" + e.getMessage()), (Throwable)e);
        }
    }

    private boolean isModified() {
        if (this.curLastModified != this.lastModified) {
            this.curLastModified = this.lastModified;
            return true;
        }
        return false;
    }

    public T read() throws Exception {
        return this.memoryValue;
    }

    public void addDataChangedListener(DataListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.dataListeners.add(listener);
        listener.dataChanged(null, this.memoryValue);
    }

    public List<DataListener<T>> getDataListeners() {
        return this.dataListeners;
    }

    public T getValueFromSource() throws IOException {
        try {
            String content = this.configService.getConfig(this.dataId, this.groupId, this.timerPeriod);
            return (T)this.converterInterface.convert((Object)content);
        }
        catch (NacosException e) {
            LogUtil.warn((String)"getValueFromSource serverAddr: {}, namespaceId: {}, dataId: {}, groupId: {}, Exception ", (Object[])new Object[]{this.serverAddr, this.namespaceId, this.dataId, this.groupId, e});
            return null;
        }
    }

    public void close() throws Exception {
        if (this.configService != null) {
            this.configService.shutDown();
        }
    }
}

