/*
 * Decompiled with CFR 0.152.
 */
package io.appactive.channel.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import io.appactive.java.api.channel.ConfigWriteDataSource;
import io.appactive.java.api.channel.ConverterInterface;
import io.appactive.java.api.channel.listener.DataListener;
import io.appactive.support.log.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class NacosWriteDataSource<T>
implements ConfigWriteDataSource<T> {
    private final ConverterInterface<T, String> converterInterface;
    private List<DataListener<T>> dataListeners = new ArrayList<DataListener<T>>();
    private String serverAddr;
    private String dataId;
    private String groupId;
    private String namespaceId;
    private ConfigService configService;
    private long timerPeriod = 3000L;
    private T memoryValue = null;
    private long lastModified = 0L;
    private long curLastModified = -1L;

    public NacosWriteDataSource(String serverAddr, String dataId, String groupId, ConverterInterface<T, String> converterInterface) {
        this(serverAddr, dataId, groupId, "", converterInterface);
    }

    public NacosWriteDataSource(String serverAddr, String dataId, String groupId, String namespaceId, ConverterInterface<T, String> converterInterface) {
        this.serverAddr = serverAddr;
        this.dataId = dataId;
        this.groupId = groupId;
        this.namespaceId = namespaceId;
        this.converterInterface = converterInterface;
        this.startTimerService();
    }

    private void startTimerService() {
        try {
            Properties properties = new Properties();
            properties.put("serverAddr", this.serverAddr);
            properties.put("namespace", this.namespaceId);
            this.configService = NacosFactory.createConfigService((Properties)properties);
        }
        catch (NacosException e) {
            LogUtil.error((String)"get Nacos configService Exception ", (Throwable)e);
        }
    }

    public boolean write(T value) throws Exception {
        return this.write(value, ConfigType.JSON.getType());
    }

    public boolean write(T value, String type) throws Exception {
        return this.syncWriteNacos(value, type);
    }

    private boolean syncWriteNacos(T value, String type) throws Exception {
        try {
            String convertResult = (String)this.converterInterface.convert(value);
            return this.configService.publishConfig(this.dataId, this.groupId, convertResult, type);
        }
        catch (Exception e) {
            LogUtil.error((String)"write Nacos config Exception ", (Throwable)e);
            return false;
        }
    }

    public void close() throws Exception {
        if (this.configService != null) {
            this.configService.shutDown();
        }
    }
}

