/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProcessor {
    private static final int QUEUE_INITIAL_CAPACITY = 8;
    private static final int DEFAULT_RETRY_INTERVAL_MILLISECONDS_WHEN_EXCEPTION = 10000;
    private static final String DEFAULT_PROCESSOR_NAME = "asyncProcessor";
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class);
    private final BlockingQueue<Runnable> queue;
    private final AtomicBoolean closed;
    private final String name;

    public AsyncProcessor() {
        this(8, DEFAULT_PROCESSOR_NAME);
    }

    public AsyncProcessor(int queueSize, String name) {
        this.queue = new ArrayBlockingQueue<Runnable>(queueSize);
        this.closed = new AtomicBoolean(false);
        this.name = name;
        new InnerWorker(name, this).start();
    }

    public void addTack(Runnable task) {
        try {
            this.queue.put(task);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    public void shutdown() {
        this.queue.clear();
        this.closed.compareAndSet(false, true);
    }

    public String getName() {
        return this.name;
    }

    private class InnerWorker
    extends Thread {
        AsyncProcessor outterAsyncProcessor;

        InnerWorker(String name, AsyncProcessor outterAsyncProcessor) {
            super(name);
            this.outterAsyncProcessor = outterAsyncProcessor;
        }

        @Override
        public void run() {
            while (!AsyncProcessor.this.closed.get()) {
                Runnable task = null;
                try {
                    task = (Runnable)AsyncProcessor.this.queue.take();
                    long begin = System.currentTimeMillis();
                    task.run();
                    long duration = System.currentTimeMillis();
                    LOGGER.info("runner[{}] executed task {} cost {} ms", new Object[]{this.getName(), task, duration - begin});
                }
                catch (Exception e) {
                    LOGGER.error(String.format("task running failed with retry milli interval %d. exception msg: %s.", 10000, e.toString()), (Throwable)e);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                    if (this.outterAsyncProcessor == null || task == null) continue;
                    this.outterAsyncProcessor.addTack(task);
                }
            }
        }
    }
}

