/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.AliyunConst;
import com.alibaba.nacos.client.aliyun.AsyncProcessor;
import com.alibaba.nacos.client.aliyun.KmsEncryptor;
import com.aliyun.dkms.gcs.openapi.models.Config;
import com.aliyun.kms.KmsTransferAcsClient;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.aliyuncs.kms.model.v20160120.DescribeKeyRequest;
import com.aliyuncs.kms.model.v20160120.DescribeKeyResponse;
import com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyRequest;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyResponse;
import com.aliyuncs.kms.model.v20160120.SetDeletionProtectionRequest;
import com.aliyuncs.profile.DefaultProfile;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientKeyKmsEncryptor
extends KmsEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientKeyKmsEncryptor.class);
    private IAcsClient kmsClient;
    private String keyId;
    private Exception localInitException;
    private final Set<String> addedKeys = new HashSet<String>();
    private AsyncProcessor asyncProcessor;

    public ClientKeyKmsEncryptor(Properties properties) {
        super(properties);
        this.keyId = properties.getProperty("keyId", System.getProperty("keyId", System.getenv("keyId")));
        if (StringUtils.isBlank((CharSequence)this.keyId)) {
            String errorMsg = "keyId is not set up yet, unable to encrypt the configuration.";
            this.localInitException = new RuntimeException(errorMsg);
            LOGGER.error(AliyunConst.formatHelpMessage(errorMsg));
        } else {
            LOGGER.info("using keyId {}.", (Object)this.keyId);
        }
        try {
            this.kmsClient = this.createKmsV3Client(properties);
        }
        catch (ClientException e) {
            this.localInitException = e;
        }
        if (this.localInitException == null) {
            try {
                this.asyncProcessor = new AsyncProcessor();
            }
            catch (Exception e) {
                LOGGER.error("init async processor failed.", (Throwable)e);
            }
        }
    }

    @Override
    public String encrypt(String plainText) throws Exception {
        AtomicReference resultContent = new AtomicReference();
        EncryptRequest encReq = new EncryptRequest();
        encReq.setProtocol(ProtocolType.HTTPS);
        encReq.setAcceptFormat(FormatType.XML);
        encReq.setMethod(MethodType.POST);
        encReq.setKeyId(this.keyId);
        encReq.setPlaintext(plainText);
        this.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(((EncryptResponse)this.kmsClient.getAcsResponse((AcsRequest)encReq)).getCiphertextBlob());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)resultContent.get()))) {
                return false;
            }
            return true;
        }, 3, 3000L);
        return (String)resultContent.get();
    }

    @Override
    public String decrypt(String content) throws Exception {
        AtomicReference resultContent = new AtomicReference();
        DecryptRequest decReq = new DecryptRequest();
        decReq.setSysProtocol(ProtocolType.HTTPS);
        decReq.setSysMethod(MethodType.POST);
        decReq.setAcceptFormat(FormatType.XML);
        decReq.setCiphertextBlob(content);
        this.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(((DecryptResponse)this.kmsClient.getAcsResponse((AcsRequest)decReq)).getPlaintext());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)resultContent.get()))) {
                return false;
            }
            return true;
        }, 3, 3000L);
        return (String)resultContent.get();
    }

    private IAcsClient createKmsV3Client(Properties properties) throws ClientException {
        Config config = new Config();
        config.setProtocol("https");
        DefaultProfile profile = null;
        String kmsClientKeyContent = properties.getProperty("kmsClientKeyContent", System.getProperty("kmsClientKeyContent", System.getenv("kmsClientKeyContent")));
        if (!StringUtils.isBlank((CharSequence)kmsClientKeyContent)) {
            LOGGER.info("using {}: {}.", (Object)"kmsClientKeyContent", (Object)kmsClientKeyContent);
            config.setClientKeyContent(kmsClientKeyContent);
        } else {
            String errorMsg = null;
            LOGGER.info("{} is empty, will read from file.", (Object)"kmsClientKeyContent");
            String kmsClientKeyFilePath = properties.getProperty("kmsClientKeyFilePath", System.getProperty("kmsClientKeyFilePath", System.getenv("kmsClientKeyFilePath")));
            if (!StringUtils.isBlank((CharSequence)kmsClientKeyFilePath)) {
                String s = this.readFileToString(kmsClientKeyFilePath);
                if (!StringUtils.isBlank((CharSequence)s)) {
                    LOGGER.info("using kmsClientKeyFilePath: {}.", (Object)kmsClientKeyFilePath);
                    config.setClientKeyFile(kmsClientKeyFilePath);
                } else {
                    errorMsg = "both config from kmsClientKeyContent and kmsClientKeyFilePath is empty";
                }
            } else {
                errorMsg = "kmsClientKeyFilePath and kmsClientKeyContent are both empty";
            }
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                this.localInitException = new RuntimeException(errorMsg);
                return null;
            }
        }
        String kmsEndpoint = properties.getProperty("kmsEndpoint", System.getProperty("kmsEndpoint", System.getenv("kmsEndpoint")));
        if (StringUtils.isBlank((CharSequence)kmsEndpoint)) {
            String errorMsg = String.format("%s is empty", "kmsEndpoint");
            this.localInitException = new RuntimeException(errorMsg);
            return null;
        }
        LOGGER.info("using kmsEndpoint: {}.", (Object)kmsEndpoint);
        config.setEndpoint(kmsEndpoint);
        String kmsPassword = properties.getProperty("kmsPasswordKey", System.getProperty("kmsPasswordKey", System.getenv("kmsPasswordKey")));
        if (StringUtils.isBlank((CharSequence)kmsPassword)) {
            String errorMsg = String.format("%s is empty", "kmsPasswordKey");
            this.localInitException = new RuntimeException(errorMsg);
            return null;
        }
        LOGGER.info("using kmsPassword prefix: {}.", (Object)kmsPassword.substring(kmsPassword.length() / 8));
        config.setPassword(kmsPassword);
        String kmsCaFileContent = properties.getProperty("kmsCaFileContent", System.getProperty("kmsCaFileContent", System.getenv("kmsCaFileContent")));
        if (!StringUtils.isBlank((CharSequence)kmsCaFileContent)) {
            LOGGER.info("using {}: {}.", (Object)"kmsCaFileContent", (Object)kmsCaFileContent);
            config.setCa(kmsCaFileContent);
        } else {
            String errorMsg = null;
            LOGGER.info("{} is empty, will read from file.", (Object)"kmsCaFileContent");
            String kmsCaFilePath = properties.getProperty("kmsCaFilePath", System.getProperty("kmsCaFilePath", System.getenv("kmsCaFilePath")));
            if (!StringUtils.isBlank((CharSequence)kmsCaFilePath)) {
                config.setCaFilePath(kmsCaFilePath);
            } else {
                errorMsg = "kmsCaFilePath is empty";
                config.setCaFilePath(null);
            }
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                LOGGER.warn(AliyunConst.formatHelpMessage(errorMsg));
                profile = DefaultProfile.getProfile((String)config.getRegionId(), (String)"ak", (String)"sk", (String)"sts");
                HttpClientConfig httpClientConfig = HttpClientConfig.getDefault();
                httpClientConfig.setIgnoreSSLCerts(true);
                profile.setHttpClientConfig(httpClientConfig);
            }
        }
        if (profile == null) {
            return new KmsTransferAcsClient(config);
        }
        return new KmsTransferAcsClient(profile, config);
    }

    @Override
    public KmsEncryptor.DataKey generateDataKey(String keySpec) throws Exception {
        GenerateDataKeyRequest generateDataKeyRequest = new GenerateDataKeyRequest();
        generateDataKeyRequest.setAcceptFormat(FormatType.XML);
        generateDataKeyRequest.setKeyId(this.keyId);
        generateDataKeyRequest.setKeySpec(keySpec);
        AtomicReference resultContent = new AtomicReference();
        this.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(this.kmsClient.getAcsResponse((AcsRequest)generateDataKeyRequest));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (resultContent.get() == null) {
                return false;
            }
            return true;
        }, 3, 3000L);
        KmsEncryptor.DataKey dataKey = new KmsEncryptor.DataKey();
        dataKey.setEncryptedDataKey(((GenerateDataKeyResponse)resultContent.get()).getCiphertextBlob());
        dataKey.setPlainDataKey(((GenerateDataKeyResponse)resultContent.get()).getPlaintext());
        return dataKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void protectKeyId() {
        if (!this.addedKeys.contains(this.keyId)) {
            Set<String> set = this.addedKeys;
            synchronized (set) {
                if (this.addedKeys.contains(this.keyId)) {
                    return;
                }
                this.addedKeys.add(this.keyId);
                this.asyncProcessor.addTack(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (ClientKeyKmsEncryptor.this.kmsClient == null) {
                                    LOGGER.error("kms client hasn't initiated.");
                                    return;
                                }
                                DescribeKeyRequest describeKeyRequest = new DescribeKeyRequest();
                                describeKeyRequest.setKeyId(ClientKeyKmsEncryptor.this.keyId);
                                try {
                                    DescribeKeyResponse describeKeyResponse = (DescribeKeyResponse)ClientKeyKmsEncryptor.this.kmsClient.getAcsResponse((AcsRequest)describeKeyRequest);
                                    if (describeKeyResponse.getKeyMetadata() != null) {
                                        if (!"Enabled".equals(describeKeyResponse.getKeyMetadata().getKeyState())) {
                                            throw new RuntimeException("Key not available");
                                        }
                                        String arn = describeKeyResponse.getKeyMetadata().getArn();
                                        LOGGER.info("set deletion protection for keyId[{}], arn[{}]", (Object)ClientKeyKmsEncryptor.this.keyId, (Object)arn);
                                        SetDeletionProtectionRequest setDeletionProtectionRequest = new SetDeletionProtectionRequest();
                                        setDeletionProtectionRequest.setProtectedResourceArn(arn);
                                        setDeletionProtectionRequest.setEnableDeletionProtection(Boolean.valueOf(true));
                                        setDeletionProtectionRequest.setDeletionProtectionDescription("key is used by mse");
                                        try {
                                            ClientKeyKmsEncryptor.this.kmsClient.getAcsResponse((AcsRequest)setDeletionProtectionRequest);
                                            break block9;
                                        }
                                        catch (ClientException e) {
                                            LOGGER.error("set deletion protect failed, keyId: {}.", (Object)ClientKeyKmsEncryptor.this.keyId);
                                            throw e;
                                        }
                                    }
                                    ClientKeyKmsEncryptor.this.addedKeys.remove(ClientKeyKmsEncryptor.this.keyId);
                                    LOGGER.warn("keyId meta is null, cannot set key protection");
                                }
                                catch (ClientException e) {
                                    LOGGER.error("describe key failed, keyId: {}.", (Object)ClientKeyKmsEncryptor.this.keyId);
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                ClientKeyKmsEncryptor.this.addedKeys.remove(ClientKeyKmsEncryptor.this.keyId);
                                LOGGER.error("execute async task failed", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public void checkIfKmsClientIsReady() throws Exception {
        if (this.kmsClient == null) {
            if (this.localInitException != null) {
                throw this.localInitException;
            }
            throw new RuntimeException("kms client isn't initialized. For more information, please check: https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        }
    }

    @Override
    public void checkKeyId() throws Exception {
        this.throwExceptionIfStringBlankWithErrorKey(this.keyId, "", "keyId is not set.", "keyId");
    }

    @Override
    public void close() throws IOException {
        this.asyncProcessor.shutdown();
    }
}

