/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.aliyun.auth.injector.ConfigExtensionResourceInjector;
import com.alibaba.nacos.client.aliyun.auth.injector.NamingExtensionResourceInjector;
import com.alibaba.nacos.client.aliyun.auth.provider.AutoRotateCredentialsProvider;
import com.alibaba.nacos.client.aliyun.auth.provider.CredentialsUriCredentialsProvider;
import com.alibaba.nacos.client.aliyun.auth.provider.ExtensionCredentialsProvider;
import com.alibaba.nacos.client.aliyun.auth.provider.OidcRoleArnCredentialsProvider;
import com.alibaba.nacos.client.aliyun.auth.provider.RamRoleArnCredentialsProvider;
import com.alibaba.nacos.client.aliyun.auth.provider.StsTokenCredentialsProvider;
import com.alibaba.nacos.client.auth.ram.RamContext;
import com.alibaba.nacos.client.auth.ram.injector.AbstractResourceInjector;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.AbstractClientAuthService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunExtensionClientAuthServiceImpl
extends AbstractClientAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunExtensionClientAuthServiceImpl.class);
    private final Set<ExtensionCredentialsProvider> credentialsProviders = new HashSet<ExtensionCredentialsProvider>();
    private final Map<String, AbstractResourceInjector> resourceInjectors;
    private ExtensionCredentialsProvider matchedProvider;

    public AliyunExtensionClientAuthServiceImpl() {
        this.credentialsProviders.add(new CredentialsUriCredentialsProvider());
        this.credentialsProviders.add(new StsTokenCredentialsProvider());
        this.credentialsProviders.add(new OidcRoleArnCredentialsProvider());
        this.credentialsProviders.add(new RamRoleArnCredentialsProvider());
        this.credentialsProviders.add(new AutoRotateCredentialsProvider());
        this.resourceInjectors = new HashMap<String, AbstractResourceInjector>();
        this.resourceInjectors.put("naming", new NamingExtensionResourceInjector());
        this.resourceInjectors.put("config", new ConfigExtensionResourceInjector());
    }

    public Boolean login(Properties properties) {
        for (ExtensionCredentialsProvider each : this.credentialsProviders) {
            if (!each.matchProvider(properties)) continue;
            if (null == this.matchedProvider) {
                LOGGER.info("Match credentials provider: {}", (Object)each.getClass().getName());
            }
            this.matchedProvider = each;
            break;
        }
        try {
            if (null == this.matchedProvider) {
                return false;
            }
            this.matchedProvider.init(properties);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Init for Credential Provider {} failed.", (Object)this.matchedProvider.getClass().getName(), (Object)e);
            return false;
        }
    }

    public LoginIdentityContext getLoginIdentityContext(RequestResource resource) {
        LoginIdentityContext result = new LoginIdentityContext();
        if (null == this.matchedProvider) {
            return result;
        }
        ExtensionRamContext ramContext = this.matchedProvider.getCredentialsForNacosClient();
        if (!ramContext.validate() || this.notFountInjector(resource.getType())) {
            return result;
        }
        this.resourceInjectors.get(resource.getType()).doInject(resource, (RamContext)ramContext, result);
        return result;
    }

    private boolean notFountInjector(String type) {
        if (!this.resourceInjectors.containsKey(type)) {
            LOGGER.warn("Injector for type {} not found, will use default ram identity context.", (Object)type);
            return true;
        }
        return false;
    }

    public void shutdown() throws NacosException {
        if (null != this.matchedProvider) {
            this.matchedProvider.shutdown();
        }
    }
}

