/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.sample;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.aliyun.AliyunConst;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class KmsV3Sample {
    public static Properties properties;
    public static final List<String> dataIdListPost;
    public static final String content = "crypt";
    public static final String group = "default";

    public static void main(String[] args) throws NacosException {
        properties = new Properties();
        properties.put("serverAddr", "serverAddr");
        properties.put("namespace", "ns");
        properties.put("accessKey", "ak");
        properties.put("secretKey", "value of sk");
        properties.put("regionId", "value of regionId");
        properties.put("kms_region_id", "value of kms_region_id");
        properties.put("kmsEndpoint", "value of kmsEndpoint");
        properties.put("keyId", "value of keyId");
        properties.put("kmsPasswordKey", "value of kmsPasswordKey");
        properties.put("kmsClientKeyContent", "value of kmsClientKey");
        properties.put("kmsCaFileContent", "value of kmsCaFile");
        properties.put("kmsVersion", AliyunConst.KmsVersion.Kmsv3.getValue());
        ConfigService configService = NacosFactory.createConfigService((Properties)properties);
        System.out.println("------config loop------");
        for (String dataId : dataIdListPost) {
            boolean b = configService.publishConfig(dataId, group, content);
            if (!b) {
                System.out.println("publish config: dataId=" + dataId + ",publishConfig failed");
                continue;
            }
            System.out.println("publish config: dataId=" + dataId + ",publishConfig success");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String content = configService.getConfig(dataId, group, 5000L);
            System.out.println("get config: dataId=" + dataId + ",content=" + content);
        }
    }

    static {
        dataIdListPost = new ArrayList<String>(){
            {
                this.add("common-config");
                this.add("cipher-kms-aes-256-crypt");
            }
        };
    }
}

