/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.logger.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher {
    public static final Logger log = LogUtils.logger(EventDispatcher.class);
    static final Map<Class<? extends AbstractEvent>, CopyOnWriteArrayList<AbstractEventListener>> LISTENER_MAP = new HashMap<Class<? extends AbstractEvent>, CopyOnWriteArrayList<AbstractEventListener>>();

    public static void addEventListener(AbstractEventListener listener) {
        for (Class<? extends AbstractEvent> type : listener.interest()) {
            EventDispatcher.getListenerList(type).addIfAbsent(listener);
        }
    }

    public static void fireEvent(AbstractEvent abstractEvent) {
        if (null == abstractEvent) {
            return;
        }
        for (AbstractEvent implyEvent : abstractEvent.implyEvents()) {
            try {
                if (abstractEvent == implyEvent) continue;
                EventDispatcher.fireEvent(implyEvent);
            }
            catch (Exception e) {
                log.warn("", e.toString(), e);
            }
        }
        for (AbstractEventListener listener : EventDispatcher.getListenerList(abstractEvent.getClass())) {
            try {
                listener.onEvent(abstractEvent);
            }
            catch (Exception e) {
                log.warn(e.toString(), e);
            }
        }
    }

    static synchronized CopyOnWriteArrayList<AbstractEventListener> getListenerList(Class<? extends AbstractEvent> eventType) {
        CopyOnWriteArrayList<AbstractEventListener> listeners = LISTENER_MAP.get(eventType);
        if (null == listeners) {
            listeners = new CopyOnWriteArrayList();
            LISTENER_MAP.put(eventType, listeners);
        }
        return listeners;
    }

    public static class ServerlistChangeEvent
    extends AbstractEvent {
    }

    public static abstract class AbstractEventListener {
        public AbstractEventListener() {
            EventDispatcher.addEventListener(this);
        }

        public abstract List<Class<? extends AbstractEvent>> interest();

        public abstract void onEvent(AbstractEvent var1);
    }

    public static abstract class AbstractEvent {
        protected List<AbstractEvent> implyEvents() {
            return Collections.EMPTY_LIST;
        }
    }
}

