/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.beat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BeatReactor {
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("com.alibaba.nacos.naming.beat.sender");
        return thread;
    });
    private long clientBeatInterval = 10000L;
    private NamingProxy serverProxy;
    public final Map<String, BeatInfo> dom2Beat = new ConcurrentHashMap<String, BeatInfo>();

    public BeatReactor(NamingProxy serverProxy) {
        this.serverProxy = serverProxy;
        this.executorService.scheduleAtFixedRate(new BeatProcessor(), 0L, this.clientBeatInterval, TimeUnit.MILLISECONDS);
    }

    public void addBeatInfo(String dom, BeatInfo beatInfo) {
        this.dom2Beat.put(dom, beatInfo);
    }

    public void removeBeatInfo(String dom) {
        this.dom2Beat.remove(dom);
    }

    class BeatTask
    implements Runnable {
        BeatInfo beatInfo;

        public BeatTask(BeatInfo beatInfo) {
            this.beatInfo = beatInfo;
        }

        @Override
        public void run() {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("beat", JSON.toJSONString((Object)this.beatInfo));
            params.put("dom", this.beatInfo.getDom());
            try {
                String result = BeatReactor.this.serverProxy.callAllServers("/nacos/v1/ns/api/clientBeat", params);
                JSONObject jsonObject = JSON.parseObject((String)result);
                if (jsonObject != null) {
                    BeatReactor.this.clientBeatInterval = jsonObject.getLong("clientBeatInterval");
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("CLIENT-BEAT", "failed to send beat: " + JSON.toJSONString((Object)this.beatInfo), e);
            }
        }
    }

    class BeatProcessor
    implements Runnable {
        BeatProcessor() {
        }

        @Override
        public void run() {
            try {
                for (Map.Entry<String, BeatInfo> entry : BeatReactor.this.dom2Beat.entrySet()) {
                    BeatInfo beatInfo = entry.getValue();
                    BeatReactor.this.executorService.schedule(new BeatTask(beatInfo), 0L, TimeUnit.MILLISECONDS);
                    LogUtils.LOG.info("BEAT", "send beat to server: ", beatInfo.toString());
                }
            }
            catch (Exception e) {
                LogUtils.LOG.error("CLIENT-BEAT", "Exception while scheduling beat.", e);
            }
        }
    }
}

