/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.impl.EventDispatcher;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.ServerAddressIterator;
import com.alibaba.nacos.client.config.impl.TimerService;
import com.alibaba.nacos.client.config.utils.IOUtils;
import com.alibaba.nacos.client.utils.EnvUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ServerListManager {
    private static final Logger LOGGER = LogUtils.logger(ServerListManager.class);
    private String name;
    private String namespace = "";
    private String tenant = "";
    public static final String DEFAULT_NAME = "default";
    public static final String CUSTOM_NAME = "custom";
    public static final String FIXED_NAME = "fixed";
    private int initServerlistRetryTimes = 5;
    static final int TIMEOUT = 5000;
    final boolean isFixed;
    boolean isStarted = false;
    private String endpoint;
    private int endpointPort = 8080;
    private String contentPath = ParamUtil.getDefaultContextPath();
    private String serverListName = ParamUtil.getDefaultNodesPath();
    volatile List<String> serverUrls = new ArrayList<String>();
    private volatile String currentServerAddr;
    public String serverPort = ParamUtil.getDefaultServerPort();
    public String addressServerUrl;

    public ServerListManager() {
        this.isFixed = false;
        this.isStarted = false;
        this.name = DEFAULT_NAME;
    }

    public ServerListManager(List<String> fixed) {
        this(fixed, null);
    }

    public ServerListManager(List<String> fixed, String namespace) {
        this.isFixed = true;
        this.isStarted = true;
        ArrayList<String> serverAddrs = new ArrayList<String>();
        for (String serverAddr : fixed) {
            String[] serverAddrArr = serverAddr.split(":");
            if (serverAddrArr.length == 1) {
                serverAddrs.add(serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                continue;
            }
            serverAddrs.add(serverAddr);
        }
        this.serverUrls = new ArrayList<String>(serverAddrs);
        if (StringUtils.isBlank(namespace)) {
            this.name = "fixed-" + this.getFixedNameSuffix(serverAddrs.toArray(new String[serverAddrs.size()]));
        } else {
            this.namespace = namespace;
            this.name = "fixed-" + this.getFixedNameSuffix(serverAddrs.toArray(new String[serverAddrs.size()])) + "-" + namespace;
        }
    }

    public ServerListManager(String host, int port) {
        this.isFixed = false;
        this.isStarted = false;
        this.name = "custom-" + host + "-" + port;
        this.addressServerUrl = String.format("http://%s:%d/%s/%s", host, port, this.contentPath, this.serverListName);
    }

    public ServerListManager(String endpoint) throws NacosException {
        this(endpoint, null);
    }

    public ServerListManager(String endpoint, String namespace) throws NacosException {
        this.isFixed = false;
        this.isStarted = false;
        if (StringUtils.isBlank(endpoint)) {
            throw new NacosException(-400, "endpoint is blank");
        }
        if (StringUtils.isBlank(namespace)) {
            this.name = endpoint;
            this.addressServerUrl = String.format("http://%s:%d/%s/%s", endpoint, this.endpointPort, this.contentPath, this.serverListName);
        } else {
            if (StringUtils.isBlank(endpoint)) {
                throw new NacosException(-400, "endpoint is blank");
            }
            this.name = endpoint + "-" + namespace;
            this.namespace = namespace;
            this.tenant = namespace;
            this.addressServerUrl = String.format("http://%s:%d/%s/%s?namespace=%s", endpoint, this.endpointPort, this.contentPath, this.serverListName, namespace);
        }
    }

    public ServerListManager(Properties properties) throws NacosException {
        this.isStarted = false;
        String serverAddrsStr = properties.getProperty("serverAddr");
        String namespace = properties.getProperty("namespace");
        this.initParam(properties);
        if (StringUtils.isNotEmpty(serverAddrsStr)) {
            String[] serverAddrsArr;
            this.isFixed = true;
            ArrayList<String> serverAddrs = new ArrayList<String>();
            for (String serverAddr : serverAddrsArr = serverAddrsStr.split(",")) {
                String[] serverAddrArr = serverAddr.split(":");
                if (serverAddrArr.length == 1) {
                    serverAddrs.add(serverAddrArr[0] + ":" + ParamUtil.getDefaultServerPort());
                    continue;
                }
                serverAddrs.add(serverAddr);
            }
            this.serverUrls = serverAddrs;
            if (StringUtils.isBlank(namespace)) {
                this.name = "fixed-" + this.getFixedNameSuffix(this.serverUrls.toArray(new String[this.serverUrls.size()]));
            } else {
                this.namespace = namespace;
                this.tenant = namespace;
                this.name = "fixed-" + this.getFixedNameSuffix(this.serverUrls.toArray(new String[this.serverUrls.size()])) + "-" + namespace;
            }
        } else {
            if (StringUtils.isBlank(this.endpoint)) {
                throw new NacosException(-400, "endpoint is blank");
            }
            this.isFixed = false;
            if (StringUtils.isBlank(namespace)) {
                this.name = this.endpoint;
                this.addressServerUrl = String.format("http://%s:%d/%s/%s", this.endpoint, this.endpointPort, this.contentPath, this.serverListName);
            } else {
                this.namespace = namespace;
                this.tenant = namespace;
                this.name = this.endpoint + "-" + namespace;
                this.addressServerUrl = String.format("http://%s:%d/%s/%s?namespace=%s", this.endpoint, this.endpointPort, this.contentPath, this.serverListName, namespace);
            }
        }
    }

    private void initParam(Properties properties) {
        String serverListNameTmp;
        String contentPathTmp;
        String endpointTmp = properties.getProperty("endpoint");
        if (!StringUtils.isBlank(endpointTmp)) {
            this.endpoint = endpointTmp;
        }
        if (!StringUtils.isBlank(contentPathTmp = properties.getProperty("contextPath"))) {
            this.contentPath = contentPathTmp;
        }
        if (!StringUtils.isBlank(serverListNameTmp = properties.getProperty("clusterName"))) {
            this.serverListName = serverListNameTmp;
        }
    }

    public synchronized void start() throws NacosException {
        if (this.isStarted || this.isFixed) {
            return;
        }
        GetServerListTask getServersTask = new GetServerListTask(this.addressServerUrl);
        for (int i = 0; i < this.initServerlistRetryTimes && this.serverUrls.isEmpty(); ++i) {
            getServersTask.run();
            try {
                this.wait((long)(i + 1) * 100L);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("get serverlist fail,url: {}", (Object)this.addressServerUrl);
            }
        }
        if (this.serverUrls.isEmpty()) {
            LOGGER.error("[init-serverlist] fail to get NACOS-server serverlist! env: {}, url: {}", (Object)this.name, (Object)this.addressServerUrl);
            throw new NacosException(500, "fail to get NACOS-server serverlist! env:" + this.name + ", not connnect url:" + this.addressServerUrl);
        }
        TimerService.scheduleWithFixedDelay(getServersTask, 0L, 30L, TimeUnit.SECONDS);
        this.isStarted = true;
    }

    Iterator<String> iterator() {
        if (this.serverUrls.isEmpty()) {
            LOGGER.error("[{}] [iterator-serverlist] No server address defined!", (Object)this.name);
        }
        return new ServerAddressIterator(this.serverUrls);
    }

    private void updateIfChanged(List<String> newList) {
        if (null == newList || newList.isEmpty()) {
            LOGGER.warn("[update-serverlist] current serverlist from address server is empty!!!");
            return;
        }
        if (newList.equals(this.serverUrls)) {
            return;
        }
        this.serverUrls = new ArrayList<String>(newList);
        this.currentServerAddr = this.iterator().next();
        EventDispatcher.fireEvent(new EventDispatcher.ServerlistChangeEvent());
        LOGGER.info("[{}] [update-serverlist] serverlist updated to {}", (Object)this.name, this.serverUrls);
    }

    private List<String> getApacheServerList(String url, String name) {
        try {
            HttpSimpleClient.HttpResult httpResult = HttpSimpleClient.httpGet(url, null, null, null, 3000L);
            if (200 == httpResult.code) {
                if (DEFAULT_NAME.equals(name)) {
                    EnvUtil.setSelfEnv(httpResult.headers);
                }
                List<String> lines = IOUtils.readLines(new StringReader(httpResult.content));
                ArrayList<String> result = new ArrayList<String>(lines.size());
                for (String serverAddr : lines) {
                    if (null == serverAddr || serverAddr.trim().isEmpty()) continue;
                    String[] ipPort = serverAddr.trim().split(":");
                    String ip = ipPort[0].trim();
                    if (ipPort.length == 1) {
                        result.add(ip + ":" + ParamUtil.getDefaultServerPort());
                        continue;
                    }
                    result.add(serverAddr);
                }
                return result;
            }
            LOGGER.error("[check-serverlist] error. addressServerUrl: {}, code: {}", (Object)this.addressServerUrl, (Object)httpResult.code);
            return null;
        }
        catch (IOException e) {
            LOGGER.error("[check-serverlist] exception. url: " + url, (Throwable)e);
            return null;
        }
    }

    String getUrlString() {
        return this.serverUrls.toString();
    }

    String getFixedNameSuffix(String ... serverIps) {
        StringBuilder sb = new StringBuilder();
        String split = "";
        for (String serverIp : serverIps) {
            sb.append(split);
            sb.append(serverIp.replaceAll(":", "_"));
            split = "-";
        }
        return sb.toString();
    }

    public String toString() {
        return "ServerManager-" + this.name + "-" + this.getUrlString();
    }

    public boolean contain(String ip) {
        return this.serverUrls.contains(ip);
    }

    public void refreshCurrentServerAddr() {
        this.currentServerAddr = this.iterator().next();
    }

    public String getCurrentServerAddr() {
        if (StringUtils.isBlank(this.currentServerAddr)) {
            this.currentServerAddr = this.iterator().next();
        }
        return this.currentServerAddr;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTenant() {
        return this.tenant;
    }

    class GetServerListTask
    implements Runnable {
        final String url;

        GetServerListTask(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                ServerListManager.this.updateIfChanged(ServerListManager.this.getApacheServerList(this.url, ServerListManager.this.name));
            }
            catch (Exception e) {
                LOGGER.error("[" + ServerListManager.this.name + "][update-serverlist] failed to update serverlist from address server!", (Throwable)e);
            }
        }
    }
}

